/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.hawkular.metrics.core.api.DataPoint;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import rx.Observable;

@ApiModel(description="A timestamp and a value where the value is interpreted as a signed 64 bit integer")
public class CounterDataPoint {
    private final long timestamp;
    private final long value;

    @com.fasterxml.jackson.annotation.JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @JsonCreator
    public CounterDataPoint(@JsonProperty(value="timestamp") @org.codehaus.jackson.annotate.JsonProperty(value="timestamp") Long timestamp, @JsonProperty(value="value") @org.codehaus.jackson.annotate.JsonProperty(value="value") Long value, @JsonProperty(value="tags") @org.codehaus.jackson.annotate.JsonProperty(value="tags") Map<String, String> tags) {
        Preconditions.checkArgument((timestamp != null ? 1 : 0) != 0, (Object)"Data point timestamp is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Data point value is null");
        this.timestamp = timestamp;
        this.value = value;
    }

    public CounterDataPoint(DataPoint<Long> dataPoint) {
        this.timestamp = dataPoint.getTimestamp();
        this.value = (Long)dataPoint.getValue();
    }

    @ApiModelProperty(required=true)
    public long getTimestamp() {
        return this.timestamp;
    }

    @ApiModelProperty(required=true)
    public long getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterDataPoint that = (CounterDataPoint)o;
        return this.timestamp == that.timestamp && this.value == that.value;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("value", this.value).toString();
    }

    public static List<DataPoint<Long>> asDataPoints(List<CounterDataPoint> points) {
        return Lists.transform(points, p -> new DataPoint(p.getTimestamp(), (Object)p.getValue()));
    }

    public static Observable<Metric<Long>> toObservable(String tenantId, String metricId, List<CounterDataPoint> points) {
        List<DataPoint<Long>> dataPoints = CounterDataPoint.asDataPoints(points);
        Metric metric = new Metric(new MetricId(tenantId, MetricType.COUNTER, metricId), dataPoints);
        return Observable.just((Object)metric);
    }
}

