/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hawkular.metrics.api.jaxrs.model.GaugeDataPoint;
import org.hawkular.metrics.core.api.DataPoint;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import rx.Observable;

@ApiModel(description="A gauge metric with one or more data points")
public class Gauge {
    private final String id;
    private final List<GaugeDataPoint> data;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @org.codehaus.jackson.annotate.JsonCreator
    public Gauge(@JsonProperty(value="id") @org.codehaus.jackson.annotate.JsonProperty(value="id") String id, @JsonProperty(value="data") @org.codehaus.jackson.annotate.JsonProperty(value="data") List<GaugeDataPoint> data) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Gauge id is null");
        this.id = id;
        this.data = data == null || data.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(data);
    }

    @ApiModelProperty(value="Identifier of the metric", required=true)
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="Gauge data points")
    @com.fasterxml.jackson.databind.annotation.JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public List<GaugeDataPoint> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Gauge gauge = (Gauge)o;
        return this.id.equals(gauge.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("data", this.data).omitNullValues().toString();
    }

    public static Observable<Metric<Double>> toObservable(String tenantId, List<Gauge> gauges) {
        return Observable.from(gauges).map(g -> {
            List<DataPoint<Double>> points = GaugeDataPoint.asDataPoints(g.getData());
            return new Metric(new MetricId(tenantId, MetricType.GAUGE, g.getId()), points);
        });
    }
}

