/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.hawkular.metrics.core.api.DataPoint;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import rx.Observable;

@ApiModel(description="A timestamp and a value where the value is interpreted as a floating point number")
public class GaugeDataPoint {
    private final long timestamp;
    private final double value;

    @com.fasterxml.jackson.annotation.JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @JsonCreator
    public GaugeDataPoint(@JsonProperty(value="timestamp") @org.codehaus.jackson.annotate.JsonProperty(value="timestamp") Long timestamp, @JsonProperty(value="value") @org.codehaus.jackson.annotate.JsonProperty(value="value") Double value, @JsonProperty(value="tags") @org.codehaus.jackson.annotate.JsonProperty(value="tags") Map<String, String> tags) {
        Preconditions.checkArgument((timestamp != null ? 1 : 0) != 0, (Object)"Data point timestamp is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Data point value is null");
        this.timestamp = timestamp;
        this.value = value;
    }

    public GaugeDataPoint(DataPoint<Double> dataPoint) {
        this.timestamp = dataPoint.getTimestamp();
        this.value = (Double)dataPoint.getValue();
    }

    @ApiModelProperty(required=true)
    public long getTimestamp() {
        return this.timestamp;
    }

    @ApiModelProperty(required=true)
    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GaugeDataPoint that = (GaugeDataPoint)o;
        return this.timestamp == that.timestamp && Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("value", this.value).toString();
    }

    public static List<DataPoint<Double>> asDataPoints(List<GaugeDataPoint> points) {
        return Lists.transform(points, p -> new DataPoint(p.getTimestamp(), (Object)p.getValue()));
    }

    public static Observable<Metric<Double>> toObservable(String tenantId, String metricId, List<GaugeDataPoint> points) {
        List<DataPoint<Double>> dataPoints = GaugeDataPoint.asDataPoints(points);
        Metric metric = new Metric(new MetricId(tenantId, MetricType.GAUGE, metricId), dataPoints);
        return Observable.just((Object)metric);
    }
}

