/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.param;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.hawkular.metrics.api.jaxrs.param.Duration;
import org.hawkular.metrics.api.jaxrs.param.TimeRange;
import org.hawkular.metrics.core.api.Buckets;

public class BucketConfig {
    private final Buckets buckets;
    private final boolean valid;
    private final String problem;

    public BucketConfig(Integer bucketsCount, Duration bucketDuration, TimeRange timeRange) {
        Preconditions.checkArgument((timeRange != null ? 1 : 0) != 0, (Object)"Time range is null");
        if (!timeRange.isValid()) {
            throw new IllegalArgumentException("Invalid time range: " + timeRange.getProblem());
        }
        if (bucketsCount == null && bucketDuration == null) {
            this.buckets = null;
            this.valid = true;
            this.problem = null;
        } else if (bucketsCount != null && bucketDuration != null) {
            this.buckets = null;
            this.valid = false;
            this.problem = "Both buckets and bucketDuration parameters are specified";
        } else {
            Buckets buckets = null;
            IllegalArgumentException cause = null;
            try {
                buckets = bucketsCount != null ? Buckets.fromCount((long)timeRange.getStart(), (long)timeRange.getEnd(), (int)bucketsCount) : Buckets.fromStep((long)timeRange.getStart(), (long)timeRange.getEnd(), (long)bucketDuration.toMillis());
            }
            catch (IllegalArgumentException e) {
                cause = e;
            }
            this.buckets = buckets;
            if (cause == null) {
                this.valid = true;
                this.problem = null;
            } else {
                this.valid = false;
                this.problem = cause.getMessage();
            }
        }
    }

    public Buckets getBuckets() {
        return this.buckets;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isEmpty() {
        return this.buckets == null;
    }

    public String getProblem() {
        return this.problem;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("buckets", (Object)this.buckets).add("valid", this.valid).add("problem", (Object)this.problem).omitNullValues().toString();
    }
}

