/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.model.ApiError;
import org.hawkular.metrics.api.jaxrs.model.Availability;
import org.hawkular.metrics.api.jaxrs.model.AvailabilityDataPoint;
import org.hawkular.metrics.api.jaxrs.model.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.param.BucketConfig;
import org.hawkular.metrics.api.jaxrs.param.Duration;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.param.TimeRange;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.Buckets;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricAlreadyExistsException;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import rx.Observable;

@Path(value="/availability")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AvailabilityHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    public Response createAvailabilityMetric(MetricDefinition metricDefinition, @Context UriInfo uriInfo) {
        if (metricDefinition.getType() != null && MetricType.AVAILABILITY != metricDefinition.getType()) {
            return ApiUtils.badRequest((ApiError)new ApiError("MetricDefinition type does not match " + MetricType.AVAILABILITY.getText()));
        }
        URI location = uriInfo.getBaseUriBuilder().path("/availability/{id}").build(new Object[]{metricDefinition.getId()});
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, metricDefinition.getId()), metricDefinition.getTags(), metricDefinition.getDataRetention());
        try {
            Observable observable = this.metricsService.createMetric(metric);
            observable.toBlocking().lastOrDefault(null);
            return Response.created((URI)location).build();
        }
        catch (MetricAlreadyExistsException e) {
            String message = "A metric with name [" + e.getMetric().getId().getName() + "] already exists";
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ApiError(message)).build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/")
    public Response findAvailabilityMetrics(@QueryParam(value="tags") Tags tags) {
        Observable metricObservable = tags == null ? this.metricsService.findMetrics(this.tenantId, MetricType.AVAILABILITY) : this.metricsService.findMetricsWithFilters(this.tenantId, tags.getTags(), MetricType.AVAILABILITY);
        try {
            return (Response)metricObservable.map(MetricDefinition::new).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (PatternSyntaxException e) {
            return ApiUtils.badRequest((Throwable)e);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}")
    public Response getAvailabilityMetric(@PathParam(value="id") String id) {
        try {
            return (Response)this.metricsService.findMetric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id)).map(MetricDefinition::new).map(metricDef -> Response.ok((Object)metricDef).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).toBlocking().firstOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/tags")
    public Response getMetricTags(@PathParam(value="id") String id) {
        Observable something = this.metricsService.getMetricTags(new MetricId(this.tenantId, MetricType.AVAILABILITY, id));
        try {
            return (Response)something.map(ApiUtils::valueToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @PUT
    @Path(value="/{id}/tags")
    public Response updateMetricTags(@PathParam(value="id") String id, Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id));
        try {
            this.metricsService.addTags(metric, tags).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (IllegalArgumentException e1) {
            return ApiUtils.badRequest((ApiError)new ApiError(e1.getMessage()));
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{id}/tags/{tags}")
    public Response deleteMetricTags(@PathParam(value="id") String id, @PathParam(value="tags") Tags tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id));
        try {
            this.metricsService.deleteTags(metric, tags.getTags()).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/{id}/data")
    public Response addAvailabilityForMetric(@PathParam(value="id") String id, List<AvailabilityDataPoint> data) {
        Observable metrics = AvailabilityDataPoint.toObservable((String)this.tenantId, (String)id, data);
        try {
            this.metricsService.addDataPoints(MetricType.AVAILABILITY, metrics).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/data")
    public Response addAvailabilityData(List<Availability> availabilities) {
        Observable metrics = Availability.toObservable((String)this.tenantId, availabilities);
        try {
            this.metricsService.addDataPoints(MetricType.AVAILABILITY, metrics).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/data")
    public Response findAvailabilityData(@PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration, @QueryParam(value="distinct") @DefaultValue(value="false") Boolean distinct) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (!bucketConfig.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem()));
        }
        MetricId metricId = new MetricId(this.tenantId, MetricType.AVAILABILITY, id);
        Buckets buckets = bucketConfig.getBuckets();
        try {
            if (buckets == null) {
                return (Response)this.metricsService.findAvailabilityData(metricId, timeRange.getStart(), timeRange.getEnd(), distinct.booleanValue()).map(AvailabilityDataPoint::new).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
            }
            return (Response)this.metricsService.findAvailabilityStats(metricId, timeRange.getStart(), timeRange.getEnd(), buckets).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }
}

