/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.param;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.ws.rs.ext.Provider;
import org.hawkular.metrics.model.param.Tags;
import org.jboss.resteasy.spi.StringConverter;

@Provider
public class TagsConverter
implements StringConverter<Tags> {
    public Tags fromString(String value) {
        if (value.isEmpty()) {
            return new Tags(Collections.emptyMap());
        }
        Preconditions.checkArgument((!value.trim().isEmpty() ? 1 : 0) != 0, (String)"Invalid tags: %s", (Object[])new Object[]{value});
        HashMap<String, String> tags = new HashMap<String, String>();
        String previousToken = null;
        StringTokenizer tokenizer = new StringTokenizer(value, ",", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (previousToken == null) {
                Preconditions.checkArgument((!",".equals(token) ? 1 : 0) != 0, (String)"Invalid tags: %s", (Object[])new Object[]{value});
            } else {
                Preconditions.checkArgument((!",".equals(previousToken) ? 1 : 0) != 0);
            }
            if (",".equals(token)) {
                previousToken = null;
                continue;
            }
            int colonIndex = token.indexOf(":");
            Preconditions.checkArgument((boolean)this.hasExpectedForm(token, colonIndex), (String)"Invalid tags: %s", (Object[])new Object[]{value});
            try {
                String tagValue = URLDecoder.decode(token.substring(colonIndex + 1), StandardCharsets.UTF_8.name());
                tags.put(token.substring(0, colonIndex), tagValue);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            previousToken = token;
        }
        return new Tags(tags);
    }

    private boolean hasExpectedForm(String token, int colonIndex) {
        return colonIndex > 0 && colonIndex < token.length();
    }

    public String toString(Tags value) {
        return value.getTags().entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(","));
    }
}

