/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.filter;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CorsFilter
implements Filter {
    public static final String PREFLIGHT_METHOD = "OPTIONS";

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String originHeaderValue;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String origin = "*";
        Enumeration originHeaders = httpRequest.getHeaders("Origin");
        if (originHeaders != null && originHeaders.hasMoreElements() && (originHeaderValue = (String)originHeaders.nextElement()) != null && !originHeaderValue.equals("null")) {
            origin = originHeaderValue.split(",")[0];
        }
        httpResponse.addHeader("Access-Control-Allow-Origin", origin);
        httpResponse.addHeader("Access-Control-Allow-Credentials", "true");
        httpResponse.addHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS, HEAD");
        httpResponse.addHeader("Access-Control-Max-Age", "259200");
        httpResponse.addHeader("Access-Control-Allow-Headers", "origin,accept,content-type,hawkular-tenant");
        if (!this.isPreflightRequest((HttpServletRequest)request)) {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    private boolean isPreflightRequest(HttpServletRequest request) {
        return request.getHeader("Access-Control-Request-Method") != null && request.getMethod() != null && request.getMethod().equalsIgnoreCase(PREFLIGHT_METHOD);
    }
}

