/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.model.ApiError;
import org.hawkular.metrics.api.jaxrs.model.Counter;
import org.hawkular.metrics.api.jaxrs.model.CounterDataPoint;
import org.hawkular.metrics.api.jaxrs.model.GaugeDataPoint;
import org.hawkular.metrics.api.jaxrs.model.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.param.Duration;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.Buckets;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricAlreadyExistsException;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import rx.Observable;

@Path(value="/counters")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CounterHandler {
    private static final long EIGHT_HOURS = TimeUnit.MILLISECONDS.convert(8L, TimeUnit.HOURS);
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    public Response createCounter(MetricDefinition metricDefinition, @Context UriInfo uriInfo) {
        if (metricDefinition.getType() != null && MetricType.COUNTER != metricDefinition.getType()) {
            return ApiUtils.badRequest((ApiError)new ApiError("MetricDefinition type does not match " + MetricType.COUNTER.getText()));
        }
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.COUNTER, metricDefinition.getId()), metricDefinition.getTags(), metricDefinition.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/counters/{id}").build(new Object[]{metric.getId().getName()});
        try {
            Observable observable = this.metricsService.createMetric(metric);
            observable.toBlocking().lastOrDefault(null);
            return Response.created((URI)location).build();
        }
        catch (MetricAlreadyExistsException e) {
            String message = "A metric with name [" + e.getMetric().getId().getName() + "] already exists";
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ApiError(message)).build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}")
    public Response getCounter(@PathParam(value="id") String id) {
        try {
            return (Response)this.metricsService.findMetric(new MetricId(this.tenantId, MetricType.COUNTER, id)).map(MetricDefinition::new).map(metricDef -> Response.ok((Object)metricDef).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}/tags")
    public Response getMetricTags(@PathParam(value="id") String id) {
        try {
            return (Response)this.metricsService.getMetricTags(new MetricId(this.tenantId, MetricType.COUNTER, id)).map(ApiUtils::valueToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{id}/tags")
    public Response updateMetricTags(@PathParam(value="id") String id, Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.COUNTER, id));
        try {
            this.metricsService.addTags(metric, tags).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (IllegalArgumentException e1) {
            return ApiUtils.badRequest((ApiError)new ApiError(e1.getMessage()));
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{id}/tags/{tags}")
    public Response deleteMetricTags(@PathParam(value="id") String id, @PathParam(value="tags") Tags tags) {
        try {
            Metric metric = new Metric(new MetricId(this.tenantId, MetricType.COUNTER, id));
            this.metricsService.deleteTags(metric, tags.getTags()).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/data")
    public Response addData(List<Counter> counters) {
        Observable metrics = Counter.toObservable((String)this.tenantId, counters);
        try {
            this.metricsService.addDataPoints(MetricType.COUNTER, metrics).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/{id}/data")
    public Response addData(@PathParam(value="id") String id, List<CounterDataPoint> data) {
        Observable metrics = CounterDataPoint.toObservable((String)this.tenantId, (String)id, data);
        try {
            this.metricsService.addDataPoints(MetricType.COUNTER, metrics).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/data")
    public Response findCounterData(@PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration) {
        Buckets buckets;
        long now = System.currentTimeMillis();
        long startTime = start == null ? now - EIGHT_HOURS : start;
        long endTime = end == null ? now : end;
        MetricId metricId = new MetricId(this.tenantId, MetricType.COUNTER, id);
        if (bucketsCount == null && bucketDuration == null) {
            try {
                return (Response)this.metricsService.findDataPoints(metricId, Long.valueOf(startTime), Long.valueOf(endTime)).map(CounterDataPoint::new).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
            }
            catch (Exception e) {
                return ApiUtils.serverError((Throwable)e);
            }
        }
        if (bucketsCount != null && bucketDuration != null) {
            return ApiUtils.badRequest((ApiError)new ApiError("Both buckets and bucketDuration parameters are used"));
        }
        try {
            buckets = bucketsCount != null ? Buckets.fromCount((long)startTime, (long)endTime, (int)bucketsCount) : Buckets.fromStep((long)startTime, (long)endTime, (long)bucketDuration.toMillis());
        }
        catch (IllegalArgumentException e) {
            return ApiUtils.badRequest((ApiError)new ApiError("Bucket: " + e.getMessage()));
        }
        try {
            return (Response)this.metricsService.findCounterStats(metricId, startTime, endTime, buckets).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/rate")
    public Response findRate(@PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration) {
        Buckets buckets;
        long now = System.currentTimeMillis();
        long startTime = start == null ? now - EIGHT_HOURS : start;
        long endTime = end == null ? now : end;
        MetricId metricId = new MetricId(this.tenantId, MetricType.COUNTER, id);
        if (bucketsCount == null && bucketDuration == null) {
            try {
                return (Response)this.metricsService.findRateData(metricId, startTime, endTime).map(GaugeDataPoint::new).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
            }
            catch (Exception e) {
                return ApiUtils.serverError((Throwable)e);
            }
        }
        if (bucketsCount != null && bucketDuration != null) {
            return ApiUtils.badRequest((ApiError)new ApiError("Both buckets and bucketDuration parameters are used"));
        }
        try {
            buckets = bucketsCount != null ? Buckets.fromCount((long)startTime, (long)endTime, (int)bucketsCount) : Buckets.fromStep((long)startTime, (long)endTime, (long)bucketDuration.toMillis());
        }
        catch (IllegalArgumentException e) {
            return ApiUtils.badRequest((ApiError)new ApiError("Bucket: " + e.getMessage()));
        }
        try {
            return (Response)this.metricsService.findRateStats(metricId, startTime, endTime, buckets).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }
}

