/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.filter;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.api.jaxrs.util.OriginValidation;

public class CorsFilter
implements Filter {
    private static final String PREFLIGHT_METHOD = "OPTIONS";
    @Inject
    OriginValidation validator;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.ALLOWED_CORS_ACCESS_CONTROL_ALLOW_HEADERS)
    String extraAccesControlAllowHeaders;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestOrigin = httpRequest.getHeader("Origin");
        if (requestOrigin == null) {
            chain.doFilter(request, response);
            return;
        }
        if (this.validator.isAllowedOrigin(requestOrigin)) {
            httpResponse.addHeader("Access-Control-Allow-Origin", requestOrigin);
            httpResponse.addHeader("Access-Control-Allow-Credentials", "true");
            httpResponse.addHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS, HEAD");
            httpResponse.addHeader("Access-Control-Max-Age", "259200");
            if (this.extraAccesControlAllowHeaders != null) {
                httpResponse.addHeader("Access-Control-Allow-Headers", "origin,accept,content-type,hawkular-tenant," + this.extraAccesControlAllowHeaders.trim());
            } else {
                httpResponse.addHeader("Access-Control-Allow-Headers", "origin,accept,content-type,hawkular-tenant");
            }
            if (!this.isPreflightRequest((HttpServletRequest)request)) {
                chain.doFilter(request, response);
            }
        } else {
            httpResponse.setStatus(400);
            httpResponse.setContentLength(0);
        }
    }

    private boolean isPreflightRequest(HttpServletRequest request) {
        return request.getHeader("Access-Control-Request-Method") != null && request.getMethod() != null && request.getMethod().equalsIgnoreCase(PREFLIGHT_METHOD);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }
}

