/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx.write.validation;

import java.util.List;
import org.hawkular.metrics.api.jaxrs.influx.InfluxObject;
import org.hawkular.metrics.api.jaxrs.influx.write.validation.InfluxObjectValidationRule;
import org.hawkular.metrics.api.jaxrs.influx.write.validation.InvalidObjectException;

public class DataTypesRule
implements InfluxObjectValidationRule {
    public void checkInfluxObject(InfluxObject influxObject) throws InvalidObjectException {
        List points = influxObject.getPoints();
        if (points == null) {
            return;
        }
        List columns = influxObject.getColumns();
        for (List point : points) {
            if (point.size() < columns.size()) {
                throw new InvalidObjectException("Object has not enough data in point to match columns");
            }
            for (Object data : point) {
                if (data instanceof Number) continue;
                throw new InvalidObjectException(data + " is not numerical");
            }
        }
    }
}

