/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.scheduler.impl.TestScheduler;
import org.jboss.logging.Logger;
import org.joda.time.DateTime;

@Path(value="/scheduler")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class JobSchedulerHandler {
    private Logger logger = Logger.getLogger(JobSchedulerHandler.class);
    @Inject
    private TestScheduler scheduler;

    @GET
    @Path(value="clock")
    public Response getTime() {
        return Response.ok((Object)ImmutableMap.of((Object)"time", (Object)this.scheduler.now())).build();
    }

    @PUT
    @Path(value="clock")
    public Response setTime(Map<String, Object> params) {
        Long time = (Long)params.get("time");
        DateTime timeSlice = new DateTime((Object)time);
        try {
            CountDownLatch timeSliceFinished = new CountDownLatch(1);
            this.scheduler.onTimeSliceFinished(finishedTimeSlice -> {
                if (finishedTimeSlice.equals((Object)timeSlice)) {
                    timeSliceFinished.countDown();
                }
            });
            this.scheduler.advanceTimeTo(time.longValue());
            boolean finished = timeSliceFinished.await(30L, TimeUnit.SECONDS);
            if (finished) {
                return Response.ok().build();
            }
            String msg = "The job scheduler did not finish its work for time slice [" + timeSlice.toDate() + "]";
            return Response.serverError().type("application/json").entity((Object)new ApiError(msg)).build();
        }
        catch (InterruptedException e) {
            String msg = "There was an interrupt while waiting for the job scheduler to finish its work for time slice [" + timeSlice.toDate() + "]";
            this.logger.warn((Object)msg, (Throwable)e);
            return Response.serverError().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(msg)).build();
        }
        catch (Exception e) {
            String msg = "There was an unexpected error while waiting for the job scheduler to finish its work for [" + timeSlice.toDate() + "]";
            this.logger.warn((Object)msg, (Throwable)e);
            return Response.serverError().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(msg)).build();
        }
    }
}

