/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.util;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import org.hawkular.metrics.api.jaxrs.util.SchemaVersionCheckException;
import org.hawkular.metrics.schema.SchemaService;
import org.jboss.logging.Logger;

public class SchemaVersionChecker {
    private static final Logger logger = Logger.getLogger(SchemaVersionChecker.class);

    public void waitForSchemaUpdates(Session session, String keyspace, long delay, int maxRetries) throws InterruptedException {
        String configId = "org.hawkular.metrics";
        String configName = "schema-version";
        PreparedStatement getVersion = null;
        SchemaService schemaService = new SchemaService(session, keyspace);
        String version = schemaService.getSchemaVersion();
        for (int retries = 0; maxRetries > retries; ++retries) {
            try {
                ResultSet resultSet;
                if (getVersion == null) {
                    getVersion = session.prepare("SELECT value FROM " + keyspace + ".sys_config WHERE config_id = ? AND name = ?");
                }
                if (!(resultSet = session.execute((Statement)getVersion.bind(new Object[]{configId, configName}))).isExhausted()) {
                    String schemaVersion = resultSet.one().getString(0);
                    if (version.equals(schemaVersion)) {
                        logger.infof("Hawkular Metrics schema is up to date at version %s", (Object)version);
                        return;
                    }
                    logger.infof("Hawkular Metrics schema version does not match, should be %s, present: %s, Trying again in %d ms", (Object)version, (Object)schemaVersion, (Object)delay);
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Version check failed", (Throwable)e);
                } else {
                    logger.infof("Version check failed: %s", (Object)e.getMessage());
                }
                logger.infof("Trying again in %d ms", (Object)delay);
            }
            Thread.sleep(delay);
        }
        throw new SchemaVersionCheckException("Version check unsuccessful after " + maxRetries + " attempts");
    }
}

