/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.hawkular.metrics.api.jaxrs.influx.InfluxObject;
import org.hawkular.metrics.api.jaxrs.influx.InfluxSeriesHandler;
import org.hawkular.metrics.api.jaxrs.influx.InfluxTimeUnit;
import org.hawkular.metrics.api.jaxrs.influx.query.InfluxQueryParseTreeWalker;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.InfluxQueryParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.InfluxQueryParserFactory;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.QueryParseException;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.AggregatedColumnDefinition;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.BooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.ColumnDefinition;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.FunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.GroupByClause;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.ListSeriesDefinitionsParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.NumberFunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.RegularExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitions;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitionsParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.type.QueryType;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.type.QueryTypeVisitor;
import org.hawkular.metrics.api.jaxrs.influx.query.translate.ToIntervalTranslator;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.AggregationFunction;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.IllegalQueryException;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.QueryValidator;
import org.hawkular.metrics.api.jaxrs.influx.write.validation.InfluxObjectValidator;
import org.hawkular.metrics.api.jaxrs.influx.write.validation.InvalidObjectException;
import org.hawkular.metrics.core.service.MetricTypeFilter;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.jboss.logging.Logger;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import rx.Observable;
import rx.Observer;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/db/{tenantId}/series")
@Produces(value={"application/json"})
@ApplicationScoped
public class InfluxSeriesHandler {
    private static final Logger log = Logger.getLogger(InfluxSeriesHandler.class);
    private static final EnumSet<InfluxTimeUnit> TIME_PRECISION_ALLOWED = EnumSet.of(InfluxTimeUnit.SECONDS, InfluxTimeUnit.MILLISECONDS, InfluxTimeUnit.MICROSECONDS);
    private static final String GAUGE_PREFIX = "_gauge.";
    private static final String COUNTER_PREFIX = "_counter.";
    @Inject
    MetricsService metricsService;
    @Inject
    InfluxObjectValidator objectValidator;
    @Inject
    @InfluxQueryParseTreeWalker
    ParseTreeWalker parseTreeWalker;
    @Inject
    InfluxQueryParserFactory parserFactory;
    @Inject
    QueryValidator queryValidator;
    @Inject
    ToIntervalTranslator toIntervalTranslator;

    @POST
    @Consumes(value={"application/json"})
    public void write(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @QueryParam(value="time_precision") InfluxTimeUnit timePrecision, List<InfluxObject> influxObjects) {
        if (influxObjects == null) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Null objects"));
            return;
        }
        if (timePrecision != null && !TIME_PRECISION_ALLOWED.contains(timePrecision)) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Invalid time precision: " + timePrecision));
            return;
        }
        try {
            this.objectValidator.validateInfluxObjects(influxObjects);
        }
        catch (InvalidObjectException e) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, Throwables.getRootCause((Throwable)e).getMessage()));
            return;
        }
        Map<MetricType, List<Metric>> metrics = influxObjects.stream().map(influxObject -> InfluxSeriesHandler.influxToMetrics((String)tenantId, (InfluxObject)influxObject, (InfluxTimeUnit)timePrecision)).collect(Collectors.groupingBy(metric -> metric.getMetricId().getType()));
        Observable result = Observable.empty();
        if (metrics.containsKey(MetricType.GAUGE)) {
            result = result.mergeWith(this.metricsService.addDataPoints(MetricType.GAUGE, Observable.from((Iterable)metrics.get(MetricType.GAUGE)).compose((Observable.Transformer)MetricTypeFilter.GAUGE_FILTER)));
        }
        if (metrics.containsKey(MetricType.COUNTER)) {
            result = result.mergeWith(this.metricsService.addDataPoints(MetricType.COUNTER, Observable.from((Iterable)metrics.get(MetricType.COUNTER)).compose((Observable.Transformer)MetricTypeFilter.COUNTER_FILTER)));
        }
        result.subscribe((Observer)new WriteObserver(this, asyncResponse));
    }

    private static Metric<?> influxToMetrics(String tenantId, InfluxObject influxObject, InfluxTimeUnit timePrecision) {
        MetricTypeAndName metricTypeAndName = new MetricTypeAndName(influxObject.getName());
        MetricType type = metricTypeAndName.getType();
        String name = metricTypeAndName.getName();
        List influxObjectColumns = influxObject.getColumns();
        int valueColumnIndex = influxObjectColumns.indexOf("value");
        Stream<DataPoint> dataPoints = influxObject.getPoints().stream().map(objects -> {
            Number value;
            long timestamp;
            if (influxObjectColumns.size() == 1) {
                timestamp = System.currentTimeMillis();
                value = (Number)objects.get(0);
            } else {
                timestamp = ((Number)objects.get((valueColumnIndex + 1) % 2)).longValue();
                if (timePrecision != null) {
                    timestamp = timePrecision.convertTo(TimeUnit.MILLISECONDS, timestamp);
                }
                value = (Number)objects.get(valueColumnIndex);
            }
            return new DataPoint(Long.valueOf(timestamp), (Object)value);
        });
        if (type == MetricType.COUNTER) {
            List counterPoints = dataPoints.map(p -> new DataPoint(Long.valueOf(p.getTimestamp()), (Object)((Number)p.getValue()).longValue())).collect(Collectors.toList());
            return new Metric(new MetricId(tenantId, MetricType.COUNTER, name), counterPoints);
        }
        List gaugePoints = dataPoints.map(p -> new DataPoint(Long.valueOf(p.getTimestamp()), (Object)((Number)p.getValue()).doubleValue())).collect(Collectors.toList());
        return new Metric(new MetricId(tenantId, MetricType.GAUGE, name), gaugePoints);
    }

    @GET
    public void query(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @QueryParam(value="q") String queryString, @QueryParam(value="time_precision") InfluxTimeUnit timePrecision) {
        QueryType queryType;
        InfluxQueryParser.QueryContext queryContext;
        if (queryString == null || queryString.isEmpty()) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Missing query"));
            return;
        }
        if (timePrecision != null && !TIME_PRECISION_ALLOWED.contains(timePrecision)) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Invalid time precision: " + timePrecision));
            return;
        }
        InfluxQueryParser queryParser = this.parserFactory.newInstanceForQuery(queryString);
        try {
            queryContext = queryParser.query();
            queryType = (QueryType)new QueryTypeVisitor().visit((ParseTree)queryContext);
        }
        catch (QueryParseException e) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Syntactically incorrect query: " + e.getMessage()));
            return;
        }
        switch (1.$SwitchMap$org$hawkular$metrics$api$jaxrs$influx$query$parse$type$QueryType[queryType.ordinal()]) {
            case 1: {
                this.listSeries(asyncResponse, tenantId, queryContext.listSeries());
                break;
            }
            case 2: {
                this.select(asyncResponse, tenantId, queryContext.selectQuery(), timePrecision);
                break;
            }
            default: {
                asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Query not yet supported: " + queryString));
            }
        }
    }

    private void listSeries(AsyncResponse asyncResponse, String tenantId, InfluxQueryParser.ListSeriesContext listSeriesContext) {
        Pattern pattern;
        ListSeriesDefinitionsParser definitionsParser = new ListSeriesDefinitionsParser();
        this.parseTreeWalker.walk((ParseTreeListener)definitionsParser, (ParseTree)listSeriesContext);
        RegularExpression regularExpression = definitionsParser.getRegularExpression();
        if (regularExpression != null) {
            int flag = regularExpression.isCaseSensitive() ? 0 : 2;
            try {
                pattern = Pattern.compile(regularExpression.getExpression(), flag);
            }
            catch (Exception e) {
                asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, Throwables.getRootCause((Throwable)e).getMessage()));
                return;
            }
        } else {
            pattern = null;
        }
        Observable.merge((Observable)this.metricsService.findMetrics(tenantId, MetricType.GAUGE), (Observable)this.metricsService.findMetrics(tenantId, MetricType.COUNTER)).filter(metric -> pattern == null || pattern.matcher(metric.getMetricId().getName()).find()).toList().map(InfluxSeriesHandler::metricsListToListSeries).subscribe((Observer)new ReadObserver(this, asyncResponse));
    }

    private static List<InfluxObject> metricsListToListSeries(List<? extends Metric<?>> metrics) {
        ImmutableList columns = ImmutableList.of((Object)"time", (Object)"name");
        InfluxObject.Builder builder = new InfluxObject.Builder("list_series_result", (List)columns).withForeseenPoints(metrics.size());
        for (Metric<?> metric : metrics) {
            String prefix;
            MetricType type = metric.getMetricId().getType();
            if (type == MetricType.GAUGE) {
                prefix = "_gauge.";
            } else if (type == MetricType.COUNTER) {
                prefix = "_counter.";
            } else {
                log.tracef("List series query does not expect %s metric type", (Object)type);
                continue;
            }
            builder.addPoint((List)ImmutableList.of((Object)0, (Object)(prefix + metric.getMetricId().getName())));
        }
        return ImmutableList.of((Object)builder.createInfluxObject());
    }

    private void select(AsyncResponse asyncResponse, String tenantId, InfluxQueryParser.SelectQueryContext selectQueryContext, InfluxTimeUnit timePrecision) {
        Buckets buckets;
        SelectQueryDefinitionsParser definitionsParser = new SelectQueryDefinitionsParser();
        this.parseTreeWalker.walk((ParseTreeListener)definitionsParser, (ParseTree)selectQueryContext);
        SelectQueryDefinitions queryDefinitions = definitionsParser.getSelectQueryDefinitions();
        try {
            this.queryValidator.validateSelectQuery(queryDefinitions);
        }
        catch (IllegalQueryException e) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Illegal query: " + e.getMessage()));
            return;
        }
        String influxObjectName = queryDefinitions.getFromClause().getName();
        MetricTypeAndName metricTypeAndName = new MetricTypeAndName(influxObjectName);
        MetricType metricType = metricTypeAndName.getType();
        String metricName = metricTypeAndName.getName();
        BooleanExpression whereClause = queryDefinitions.getWhereClause();
        Interval timeInterval = whereClause == null ? new Interval((ReadableInstant)new Instant(0L), (ReadableInstant)Instant.now()) : this.toIntervalTranslator.toInterval(whereClause);
        if (timeInterval == null) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Invalid time interval"));
            return;
        }
        String columnName = this.getColumnName(queryDefinitions);
        try {
            buckets = this.getBucketConfig(queryDefinitions, timeInterval);
        }
        catch (IllegalArgumentException e) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, e.getMessage()));
            return;
        }
        this.metricsService.idExists(new MetricId(tenantId, metricType, metricName)).flatMap(idExists -> {
            if (idExists != Boolean.TRUE) {
                return Observable.just(null);
            }
            long start = timeInterval.getStartMillis();
            long end = timeInterval.getEndMillis();
            if (metricType == MetricType.GAUGE) {
                MetricId metricId = new MetricId(tenantId, MetricType.GAUGE, metricName);
                return this.metricsService.findDataPoints(metricId, start, end, 0, Order.DESC).toList();
            }
            if (metricType == MetricType.COUNTER) {
                MetricId metricId = new MetricId(tenantId, MetricType.COUNTER, metricName);
                return this.metricsService.findDataPoints(metricId, start, end, 0, Order.DESC).toSortedList((dataPoint, dataPoint2) -> Long.compare(dataPoint2.getTimestamp(), dataPoint.getTimestamp()));
            }
            return Observable.just(null);
        }).map(inputMetrics -> {
            if (inputMetrics == null) {
                return null;
            }
            List metrics = inputMetrics;
            if (buckets != null) {
                AggregatedColumnDefinition aggregatedColumnDefinition = (AggregatedColumnDefinition)queryDefinitions.getColumnDefinitions().get(0);
                metrics = this.applyMapping(aggregatedColumnDefinition.getAggregationFunction(), aggregatedColumnDefinition.getAggregationFunctionArguments(), inputMetrics, buckets);
            }
            if (!queryDefinitions.isOrderDesc()) {
                metrics = Lists.reverse((List)metrics);
            }
            if (queryDefinitions.getLimitClause() != null) {
                metrics = metrics.subList(0, queryDefinitions.getLimitClause().getLimit());
            }
            ArrayList<InfluxObject> objects = new ArrayList<InfluxObject>(1);
            ArrayList<String> columns = new ArrayList<String>(2);
            columns.add("time");
            columns.add(columnName);
            InfluxObject.Builder builder = new InfluxObject.Builder(influxObjectName, columns).withForeseenPoints(metrics.size());
            for (DataPoint m : metrics) {
                ArrayList<Object> data = new ArrayList<Object>();
                if (timePrecision == null) {
                    data.add(m.getTimestamp());
                } else {
                    data.add(timePrecision.convert(m.getTimestamp(), InfluxTimeUnit.MILLISECONDS));
                }
                data.add(m.getValue());
                builder.addPoint(data);
            }
            objects.add(builder.createInfluxObject());
            return objects;
        }).subscribe(objects -> {
            if (objects == null) {
                String msg = "Metric with id [" + influxObjectName + "] not found. ";
                asyncResponse.resume((Object)this.errorResponse(Response.Status.NOT_FOUND, msg));
            } else {
                Response.ResponseBuilder builder = Response.ok((Object)objects);
                asyncResponse.resume((Object)builder.build());
            }
        }, arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0));
    }

    private String getColumnName(SelectQueryDefinitions queryDefinitions) {
        if (queryDefinitions.isStarColumn()) {
            return "value";
        }
        return ((ColumnDefinition)queryDefinitions.getColumnDefinitions().get(0)).getDisplayName();
    }

    private Buckets getBucketConfig(SelectQueryDefinitions queryDefinitions, Interval timeInterval) {
        if (queryDefinitions.isStarColumn() || !(queryDefinitions.getColumnDefinitions().get(0) instanceof AggregatedColumnDefinition)) {
            return null;
        }
        GroupByClause groupByClause = queryDefinitions.getGroupByClause();
        InfluxTimeUnit bucketSizeUnit = groupByClause.getBucketSizeUnit();
        long bucketSize = bucketSizeUnit.convertTo(TimeUnit.MILLISECONDS, groupByClause.getBucketSize());
        return Buckets.fromStep((long)timeInterval.getStartMillis(), (long)timeInterval.getEndMillis(), (long)bucketSize);
    }

    private List<? extends DataPoint<? extends Number>> applyMapping(String aggregationFunction, List<FunctionArgument> aggregationFunctionArguments, List<? extends DataPoint<? extends Number>> in, Buckets buckets) {
        HashMap<Integer, ArrayList<DataPoint>> tmpMap = new HashMap<Integer, ArrayList<DataPoint>>(buckets.getCount());
        for (DataPoint<? extends Number> dataPoint : in) {
            int pos = (int)((dataPoint.getTimestamp() - buckets.getStart()) / buckets.getStep());
            ArrayList<DataPoint> bucket = (ArrayList<DataPoint>)tmpMap.get(pos);
            if (bucket == null) {
                bucket = new ArrayList<DataPoint>();
                tmpMap.put(pos, bucket);
            }
            bucket.add(new DataPoint(Long.valueOf(dataPoint.getTimestamp()), (Object)((Number)dataPoint.getValue()).doubleValue()));
        }
        ArrayList out = new ArrayList(buckets.getCount());
        TreeSet treeSet = new TreeSet(tmpMap.keySet());
        for (Integer pos : treeSet) {
            List list = (List)tmpMap.get(pos);
            double retVal = 0.0;
            boolean isSingleValue = true;
            if (list == null) continue;
            int size = list.size();
            DataPoint lastElementInList = (DataPoint)list.get(size - 1);
            DataPoint firstElementInList = (DataPoint)list.get(0);
            AggregationFunction function = AggregationFunction.findByName((String)aggregationFunction);
            switch (1.$SwitchMap$org$hawkular$metrics$api$jaxrs$influx$query$validation$AggregationFunction[function.ordinal()]) {
                case 1: {
                    for (DataPoint rnm : list) {
                        retVal += ((Double)rnm.getValue()).doubleValue();
                    }
                    log.debugf("Applying mean mapping, total = %f, size = %d", (Object)retVal, (Object)size);
                    retVal /= (double)size;
                    break;
                }
                case 2: {
                    retVal = -1.7976931348623157E308;
                    for (DataPoint rnm : list) {
                        if (!((Double)rnm.getValue() > retVal)) continue;
                        retVal = (Double)rnm.getValue();
                    }
                    break;
                }
                case 3: {
                    retVal = Double.MAX_VALUE;
                    for (DataPoint rnm : list) {
                        if (!((Double)rnm.getValue() < retVal)) continue;
                        retVal = (Double)rnm.getValue();
                    }
                    break;
                }
                case 4: {
                    for (DataPoint rnm : list) {
                        retVal += ((Double)rnm.getValue()).doubleValue();
                    }
                    break;
                }
                case 5: {
                    retVal = size;
                    break;
                }
                case 6: {
                    if (list.isEmpty()) break;
                    retVal = (Double)firstElementInList.getValue();
                    break;
                }
                case 7: {
                    if (list.isEmpty()) break;
                    retVal = (Double)lastElementInList.getValue();
                    break;
                }
                case 8: {
                    if (list.isEmpty()) break;
                    retVal = (Double)lastElementInList.getValue() - (Double)firstElementInList.getValue();
                    break;
                }
                case 9: {
                    if (list.isEmpty()) break;
                    double y = (Double)lastElementInList.getValue() - (Double)firstElementInList.getValue();
                    long t = (lastElementInList.getTimestamp() - firstElementInList.getTimestamp()) / 1000L;
                    retVal = y / (double)t;
                    break;
                }
                case 10: {
                    retVal = this.quantil(list, 50.0);
                    break;
                }
                case 11: {
                    NumberFunctionArgument argument = (NumberFunctionArgument)aggregationFunctionArguments.get(1);
                    retVal = this.quantil(list, argument.getDoubleValue());
                    break;
                }
                case 12: {
                    isSingleValue = false;
                    NumberFunctionArgument argument = (NumberFunctionArgument)aggregationFunctionArguments.get(1);
                    int numberOfTopElement = list.size() < (int)argument.getDoubleValue() ? list.size() : (int)argument.getDoubleValue();
                    for (int elementPos = 0; elementPos < numberOfTopElement; ++elementPos) {
                        out.add(list.get(elementPos));
                    }
                    break;
                }
                case 13: {
                    isSingleValue = false;
                    NumberFunctionArgument argument = (NumberFunctionArgument)aggregationFunctionArguments.get(1);
                    int numberOfBottomElement = list.size() < (int)argument.getDoubleValue() ? list.size() : (int)argument.getDoubleValue();
                    for (int elementPos = 0; elementPos < numberOfBottomElement; ++elementPos) {
                        out.add(list.get(list.size() - 1 - elementPos));
                    }
                    break;
                }
                case 14: 
                case 15: {
                    int maxCount = 0;
                    for (DataPoint rnm : list) {
                        int count = 0;
                        for (DataPoint rnm2 : list) {
                            if (((Double)rnm.getValue()).doubleValue() != ((Double)rnm2.getValue()).doubleValue()) continue;
                            ++count;
                        }
                        if (count <= maxCount) continue;
                        maxCount = count;
                        retVal = (Double)rnm.getValue();
                    }
                    break;
                }
                case 16: {
                    double meanValue = 0.0;
                    double sd = 0.0;
                    for (DataPoint rnm : list) {
                        meanValue += ((Double)rnm.getValue()).doubleValue();
                    }
                    meanValue /= (double)size;
                    for (DataPoint rnm : list) {
                        sd += Math.pow((Double)rnm.getValue() - meanValue, 2.0) / (double)(size - 1);
                    }
                    retVal = Math.sqrt(sd);
                    break;
                }
                default: {
                    log.warnf("Mapping of '%s' function not supported yet", (Object)function);
                }
            }
            if (!isSingleValue) continue;
            out.add(new DataPoint(Long.valueOf(firstElementInList.getTimestamp()), (Object)retVal));
        }
        return out;
    }

    private double quantil(List<DataPoint<Double>> in, double quantil) {
        double[] values = new double[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            values[i] = (Double)in.get(i).getValue();
        }
        return new Percentile(quantil).evaluate(values);
    }

    private Response errorResponse(Response.Status status, String message) {
        return Response.status((Response.Status)status).entity((Object)message).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ Response access$100(InfluxSeriesHandler x0, Response.Status x1, String x2) {
        return x0.errorResponse(x1, x2);
    }
}

