/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.filter;

import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.ext.Provider;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.api.jaxrs.util.Logged;
import org.jboss.logging.Logger;

@Logged
@Provider
public class RequestLoggingFilter
implements ContainerRequestFilter {
    private static Logger logger = Logger.getLogger(RequestLoggingFilter.class);
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.REQUEST_LOGGING_LEVEL)
    private String loggingLevelConfig;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.REQUEST_LOGGING_LEVEL_WRITES)
    private String writesLoggingLevelConfig;
    private Logger.Level logLevel;
    private Logger.Level writesLogLevel;

    @PostConstruct
    public void init() {
        this.logLevel = this.getLogLevel(this.loggingLevelConfig);
        this.writesLogLevel = this.getLogLevel(this.writesLoggingLevelConfig);
    }

    private Logger.Level getLogLevel(String config) {
        if (config == null) {
            return null;
        }
        switch (config) {
            case "TRACE": {
                return Logger.Level.TRACE;
            }
            case "INFO": {
                return Logger.Level.INFO;
            }
            case "WARN": {
                return Logger.Level.WARN;
            }
            case "ERROR": {
                return Logger.Level.ERROR;
            }
            case "FATAL": {
                return Logger.Level.FATAL;
            }
        }
        return Logger.Level.DEBUG;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            if (this.isRequestLoggingEnabled()) {
                if (this.isInsertDataRequest(requestContext)) {
                    if (this.writesLogLevel != null) {
                        this.logRequest(this.writesLogLevel, requestContext);
                    }
                } else if (this.logLevel != null) {
                    this.logRequest(this.logLevel, requestContext);
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to log request", (Throwable)e);
        }
    }

    private boolean isRequestLoggingEnabled() {
        return this.logLevel != null || this.writesLogLevel != null;
    }

    private boolean isInsertDataRequest(ContainerRequestContext requestContext) {
        List pathSegments = requestContext.getUriInfo().getPathSegments();
        return requestContext.getMethod().equals("POST") && !((PathSegment)pathSegments.get(pathSegments.size() - 1)).getPath().equals("query");
    }

    private void logRequest(Logger.Level level, ContainerRequestContext requestContext) {
        String request = "\nREST API request:\n--------------------------------------\npath: " + requestContext.getUriInfo().getPath() + "\nsegments: " + requestContext.getUriInfo().getPathSegments() + "\nmethod: " + requestContext.getMethod() + "\nquery parameters: " + requestContext.getUriInfo().getQueryParameters() + "\nTenant: " + requestContext.getHeaders().get((Object)"Hawkular-Tenant") + "\n--------------------------------------\n";
        logger.log(level, (Object)request);
    }
}

