/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.api.jaxrs.util.ManifestInformation;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Path(value="/")
@GZIP
@ApplicationScoped
public class BaseHandler {
    public static final String PATH = "/";
    private static final String STATIC_CACHE_CONTROL = "private, max-age=86400";
    @Inject
    ManifestInformation manifestInformation;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.ALLOWED_CORS_ACCESS_CONTROL_ALLOW_HEADERS)
    String extraAccesControlAllowHeaders;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns some basic information about the Hawkular Metrics service.", response=String.class, responseContainer="Map")
    public Response baseJSON() {
        HashMap<String, String> hawkularMetricsProperties = new HashMap<String, String>();
        hawkularMetricsProperties.put("name", "Hawkular-Metrics");
        hawkularMetricsProperties.putAll(this.manifestInformation.getAttributes());
        return Response.ok(hawkularMetricsProperties).build();
    }

    @GET
    @Produces(value={"application/xhtml+xml", "text/html"})
    public void baseHTML(@Context ServletContext context) throws Exception {
        HttpServletRequest request = (HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)ResteasyProviderFactory.getContextData(HttpServletResponse.class);
        this.addHeaders(response);
        request.getRequestDispatcher("/static/index.html").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void addHeaders(HttpServletResponse response) {
        response.addHeader("Cache-Control", STATIC_CACHE_CONTROL);
        response.addHeader("Vary", "Origin,Accept-Encoding");
        String requestOrigin = ((HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class)).getHeader("Origin");
        if (requestOrigin == null) {
            return;
        }
        response.setHeader("Access-Control-Allow-Origin", requestOrigin);
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, PATCH, DELETE, OPTIONS, HEAD");
        response.setHeader("Access-Control-Max-Age", String.valueOf(259200));
        if (this.extraAccesControlAllowHeaders != null) {
            response.setHeader("Access-Control-Allow-Headers", "origin,accept,content-type,hawkular-tenant," + this.extraAccesControlAllowHeaders.trim());
        } else {
            response.setHeader("Access-Control-Allow-Headers", "origin,accept,content-type,hawkular-tenant");
        }
    }
}

