/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.filter;

import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.hawkular.metrics.api.jaxrs.MetricsServiceLifecycle;
import org.hawkular.metrics.model.ApiError;

@Provider
@PreMatching
public class MetricsServiceStateFilter
implements ContainerRequestFilter {
    private static final String STARTING = "Service unavailable while initializing.";
    private static final String FAILED = "Internal server error.";
    private static final String STOPPED = "The service is no longer running.";
    @Inject
    private MetricsServiceLifecycle metricsServiceLifecycle;

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        UriInfo uriInfo = containerRequestContext.getUriInfo();
        String path = uriInfo.getPath();
        if (path.startsWith("/status") || path.startsWith("/")) {
            return;
        }
        if (this.metricsServiceLifecycle.getState() == MetricsServiceLifecycle.State.STARTING) {
            Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(STARTING)).build();
            containerRequestContext.abortWith(response);
        } else if (this.metricsServiceLifecycle.getState() == MetricsServiceLifecycle.State.FAILED) {
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(FAILED)).build();
            containerRequestContext.abortWith(response);
        } else if (this.metricsServiceLifecycle.getState() == MetricsServiceLifecycle.State.STOPPED || this.metricsServiceLifecycle.getState() == MetricsServiceLifecycle.State.STOPPING) {
            Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(STOPPED)).build();
            containerRequestContext.abortWith(response);
        }
    }
}

