/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs;

import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.api.jaxrs.util.Eager;
import org.hawkular.metrics.core.api.MetricsService;
import org.hawkular.metrics.core.impl.HawkularMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Eager
public class MetricsServiceProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsServiceProducer.class);
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_CQL_PORT)
    private String cqlPort;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_NODES)
    private String nodes;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_KEYSPACE)
    private String keyspace;
    private MetricsService metricsService;

    @PostConstruct
    void init() {
        LOG.info("Initializing metrics service");
        this.getMetricsService();
    }

    @Produces
    public MetricsService getMetricsService() {
        if (this.metricsService == null) {
            HawkularMetrics.Builder metricsServiceBuilder = new HawkularMetrics.Builder();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("cqlport", this.cqlPort);
            options.put("nodes", this.nodes);
            options.put("keyspace", this.keyspace);
            metricsServiceBuilder.withOptions(options);
            this.metricsService = metricsServiceBuilder.build();
        }
        return this.metricsService;
    }
}

