/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.callback;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import java.net.URI;
import java.util.function.Function;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.api.jaxrs.ApiError;

public abstract class EntityCreatedCallback<E>
implements FutureCallback<Void> {
    private final AsyncResponse asyncResponse;
    private final URI location;
    private final Class<E> alreadyExistsException;
    private final Function<E, Response> alreadyExistsResponseBuilder;

    public EntityCreatedCallback(AsyncResponse asyncResponse, URI location, Class<E> alreadyExistsExceptionType, Function<E, Response> alreadyExistsResponseBuilder) {
        this.asyncResponse = asyncResponse;
        this.location = location;
        this.alreadyExistsException = alreadyExistsExceptionType;
        this.alreadyExistsResponseBuilder = alreadyExistsResponseBuilder;
    }

    public void onSuccess(Void result) {
        this.asyncResponse.resume((Object)Response.created((URI)this.location).build());
    }

    public void onFailure(Throwable t) {
        Response response;
        if (this.alreadyExistsException.isAssignableFrom(t.getClass())) {
            response = (Response)this.alreadyExistsResponseBuilder.apply(this.alreadyExistsException.cast(t));
        } else {
            String message = "Failed to create tenant due to an unexpected error: " + Throwables.getRootCause((Throwable)t).getMessage();
            response = Response.serverError().entity((Object)new ApiError(message)).build();
        }
        this.asyncResponse.resume((Object)response);
    }
}

