/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.hawkular.metrics.api.jaxrs.ApiError;
import org.hawkular.metrics.api.jaxrs.influx.InfluxObject;
import org.hawkular.metrics.api.jaxrs.influx.InfluxSeriesHandler;
import org.hawkular.metrics.api.jaxrs.influx.query.InfluxQueryParseTreeWalker;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.InfluxQueryParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.InfluxQueryParserFactory;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.QueryParseException;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.AggregatedColumnDefinition;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.BooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.ColumnDefinition;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.FunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.GroupByClause;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.InfluxTimeUnit;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.NumberFunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitions;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitionsParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.type.QueryType;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.type.QueryTypeVisitor;
import org.hawkular.metrics.api.jaxrs.influx.query.translate.ToIntervalTranslator;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.AggregationFunction;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.IllegalQueryException;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.QueryValidator;
import org.hawkular.metrics.api.jaxrs.influx.write.validation.InfluxObjectValidator;
import org.hawkular.metrics.api.jaxrs.influx.write.validation.InvalidObjectException;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.api.jaxrs.util.StringValue;
import org.hawkular.metrics.core.api.MetricData;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import org.hawkular.metrics.core.api.NumericData;
import org.hawkular.metrics.core.api.NumericMetric;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/db/{tenantId}/series")
@Produces(value={"application/json"})
@ApplicationScoped
public class InfluxSeriesHandler {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxSeriesHandler.class);
    @Inject
    MetricsService metricsService;
    @Inject
    InfluxObjectValidator objectValidator;
    @Inject
    @InfluxQueryParseTreeWalker
    ParseTreeWalker parseTreeWalker;
    @Inject
    InfluxQueryParserFactory parserFactory;
    @Inject
    QueryValidator queryValidator;
    @Inject
    ToIntervalTranslator toIntervalTranslator;

    @POST
    @Consumes(value={"application/json"})
    public void write(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, List<InfluxObject> influxObjects) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            if (influxObjects == null) {
                return ApiUtils.badRequest((ApiError)new ApiError("Null objects"));
            }
            try {
                this.objectValidator.validateInfluxObjects(influxObjects);
            }
            catch (InvalidObjectException e) {
                return ApiUtils.badRequest((ApiError)new ApiError(e.getMessage()));
            }
            ImmutableList numericMetrics = FluentIterable.from((Iterable)influxObjects).transform(influxObject -> {
                List influxObjectColumns = influxObject.getColumns();
                int valueColumnIndex = influxObjectColumns.indexOf("value");
                List influxObjectPoints = influxObject.getPoints();
                NumericMetric numericMetric = new NumericMetric(tenantId, new MetricId(influxObject.getName()));
                for (List point : influxObjectPoints) {
                    double value;
                    long timestamp;
                    if (influxObjectColumns.size() == 1) {
                        timestamp = System.currentTimeMillis();
                        value = ((Number)point.get(0)).doubleValue();
                    } else {
                        timestamp = ((Number)point.get((valueColumnIndex + 1) % 2)).longValue();
                        value = ((Number)point.get(valueColumnIndex)).doubleValue();
                    }
                    numericMetric.addData((MetricData)new NumericData(timestamp, value));
                }
                return numericMetric;
            }).toList();
            ListenableFuture future = this.metricsService.addNumericData((List)numericMetrics);
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_VOID);
        });
    }

    @GET
    public void query(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @QueryParam(value="q") String queryString) {
        QueryType queryType;
        if (queryString == null || queryString.isEmpty()) {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing query").build());
            return;
        }
        InfluxQueryParser queryParser = this.parserFactory.newInstanceForQuery(queryString);
        InfluxQueryParser.QueryContext queryContext = queryParser.query();
        try {
            queryType = (QueryType)new QueryTypeVisitor().visit((ParseTree)queryContext);
        }
        catch (QueryParseException e) {
            StringValue errMsg = new StringValue("Syntactically incorrect query: " + e.getMessage());
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build());
            return;
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)e);
            return;
        }
        switch (3.$SwitchMap$org$hawkular$metrics$api$jaxrs$influx$query$parse$type$QueryType[queryType.ordinal()]) {
            case 1: {
                this.listSeries(asyncResponse, tenantId);
                break;
            }
            case 2: {
                this.select(asyncResponse, tenantId, queryContext.selectQuery());
                break;
            }
            default: {
                StringValue errMsg = new StringValue("Query not yet supported: " + queryString);
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build());
            }
        }
    }

    private void listSeries(AsyncResponse asyncResponse, String tenantId) {
        ListenableFuture future = this.metricsService.findMetrics(tenantId, MetricType.NUMERIC);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void select(AsyncResponse asyncResponse, String tenantId, InfluxQueryParser.SelectQueryContext selectQueryContext) {
        SelectQueryDefinitionsParser definitionsParser = new SelectQueryDefinitionsParser();
        this.parseTreeWalker.walk((ParseTreeListener)definitionsParser, (ParseTree)selectQueryContext);
        SelectQueryDefinitions queryDefinitions = definitionsParser.getSelectQueryDefinitions();
        try {
            this.queryValidator.validateSelectQuery(queryDefinitions);
        }
        catch (IllegalQueryException e) {
            StringValue errMsg = new StringValue("Illegal query: " + e.getMessage());
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build());
            return;
        }
        String metric = queryDefinitions.getFromClause().getName();
        BooleanExpression whereClause = queryDefinitions.getWhereClause();
        Interval timeInterval = whereClause == null ? new Interval((ReadableInstant)new Instant(0L), (ReadableInstant)Instant.now()) : this.toIntervalTranslator.toInterval(whereClause);
        if (timeInterval == null) {
            StringValue errMsg = new StringValue("Invalid time interval");
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build());
            return;
        }
        String columnName = this.getColumnName(queryDefinitions);
        ListenableFuture idExistsFuture = this.metricsService.idExists(metric);
        ListenableFuture loadMetricsFuture = Futures.transform((ListenableFuture)idExistsFuture, idExists -> {
            if (idExists != Boolean.TRUE) {
                return Futures.immediateFuture(null);
            }
            return this.metricsService.findNumericData(tenantId, new MetricId(metric), Long.valueOf(timeInterval.getStartMillis()), Long.valueOf(timeInterval.getEndMillis()));
        });
        ListenableFuture influxObjectTranslatorFuture = Futures.transform((ListenableFuture)loadMetricsFuture, metrics -> {
            if (metrics == null) {
                return null;
            }
            if (this.shouldApplyMapping(queryDefinitions)) {
                GroupByClause groupByClause = queryDefinitions.getGroupByClause();
                InfluxTimeUnit bucketSizeUnit = groupByClause.getBucketSizeUnit();
                long bucketSizeSec = bucketSizeUnit.convertTo(TimeUnit.SECONDS, (long)groupByClause.getBucketSize());
                AggregatedColumnDefinition aggregatedColumnDefinition = (AggregatedColumnDefinition)queryDefinitions.getColumnDefinitions().get(0);
                metrics = this.applyMapping(aggregatedColumnDefinition.getAggregationFunction(), aggregatedColumnDefinition.getAggregationFunctionArguments(), metrics, (int)bucketSizeSec, timeInterval.getStartMillis(), timeInterval.getEndMillis());
            }
            if (!queryDefinitions.isOrderDesc()) {
                metrics = Lists.reverse((List)metrics);
            }
            if (queryDefinitions.getLimitClause() != null) {
                metrics = metrics.subList(0, queryDefinitions.getLimitClause().getLimit());
            }
            ArrayList<InfluxObject> objects = new ArrayList<InfluxObject>(1);
            ArrayList<String> columns = new ArrayList<String>(2);
            columns.add("time");
            columns.add(columnName);
            InfluxObject.Builder builder = new InfluxObject.Builder(metric, columns).withForeseenPoints(metrics.size());
            for (NumericData m : metrics) {
                ArrayList<Number> data = new ArrayList<Number>();
                data.add(m.getTimestamp());
                data.add(m.getValue());
                builder.addPoint(data);
            }
            objects.add(builder.createInfluxObject());
            return objects;
        });
        Futures.addCallback((ListenableFuture)influxObjectTranslatorFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean shouldApplyMapping(SelectQueryDefinitions queryDefinitions) {
        return !queryDefinitions.isStarColumn() && queryDefinitions.getColumnDefinitions().get(0) instanceof AggregatedColumnDefinition && queryDefinitions.getGroupByClause() != null;
    }

    private String getColumnName(SelectQueryDefinitions queryDefinitions) {
        if (queryDefinitions.isStarColumn()) {
            return "value";
        }
        return ((ColumnDefinition)queryDefinitions.getColumnDefinitions().get(0)).getDisplayName();
    }

    private List<NumericData> applyMapping(String aggregationFunction, List<FunctionArgument> aggregationFunctionArguments, List<NumericData> in, int bucketLengthSec, long startTime, long endTime) {
        long timeDiff = endTime - startTime;
        int numBuckets = (int)(timeDiff / 1000L / (long)bucketLengthSec);
        HashMap<Integer, ArrayList<NumericData>> tmpMap = new HashMap<Integer, ArrayList<NumericData>>(numBuckets);
        for (NumericData rnm : in) {
            int pos = (int)((rnm.getTimestamp() - startTime) / 1000L) / bucketLengthSec;
            ArrayList<NumericData> bucket = (ArrayList<NumericData>)tmpMap.get(pos);
            if (bucket == null) {
                bucket = new ArrayList<NumericData>();
                tmpMap.put(pos, bucket);
            }
            bucket.add(rnm);
        }
        ArrayList<NumericData> out = new ArrayList<NumericData>(numBuckets);
        TreeSet keySet = new TreeSet(tmpMap.keySet());
        for (Integer pos : keySet) {
            List list = (List)tmpMap.get(pos);
            double retVal = 0.0;
            boolean isSingleValue = true;
            if (list == null) continue;
            int size = list.size();
            NumericData lastElementInList = (NumericData)list.get(size - 1);
            NumericData firstElementInList = (NumericData)list.get(0);
            AggregationFunction function = AggregationFunction.findByName((String)aggregationFunction);
            switch (3.$SwitchMap$org$hawkular$metrics$api$jaxrs$influx$query$validation$AggregationFunction[function.ordinal()]) {
                case 1: {
                    for (NumericData rnm : list) {
                        retVal += rnm.getValue();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Applying mean mapping, total = {}, size = {}", (Object)retVal, (Object)size);
                    }
                    retVal /= (double)size;
                    break;
                }
                case 2: {
                    retVal = Double.MIN_VALUE;
                    for (NumericData rnm : list) {
                        if (!(rnm.getValue() > retVal)) continue;
                        retVal = rnm.getValue();
                    }
                    break;
                }
                case 3: {
                    retVal = Double.MAX_VALUE;
                    for (NumericData rnm : list) {
                        if (!(rnm.getValue() < retVal)) continue;
                        retVal = rnm.getValue();
                    }
                    break;
                }
                case 4: {
                    for (NumericData rnm : list) {
                        retVal += rnm.getValue();
                    }
                    break;
                }
                case 5: {
                    retVal = size;
                    break;
                }
                case 6: {
                    if (list.isEmpty()) break;
                    retVal = firstElementInList.getValue();
                    break;
                }
                case 7: {
                    if (list.isEmpty()) break;
                    retVal = lastElementInList.getValue();
                    break;
                }
                case 8: {
                    if (list.isEmpty()) break;
                    retVal = lastElementInList.getValue() - firstElementInList.getValue();
                    break;
                }
                case 9: {
                    if (list.isEmpty()) break;
                    double y = lastElementInList.getValue() - firstElementInList.getValue();
                    long t = (lastElementInList.getTimestamp() - firstElementInList.getTimestamp()) / 1000L;
                    retVal = y / (double)t;
                    break;
                }
                case 10: {
                    retVal = this.quantil(list, 50.0);
                    break;
                }
                case 11: {
                    NumberFunctionArgument argument = (NumberFunctionArgument)aggregationFunctionArguments.get(1);
                    retVal = this.quantil(list, argument.getDoubleValue());
                    break;
                }
                case 12: {
                    isSingleValue = false;
                    NumberFunctionArgument argument = (NumberFunctionArgument)aggregationFunctionArguments.get(1);
                    int numberOfTopElement = list.size() < (int)argument.getDoubleValue() ? list.size() : (int)argument.getDoubleValue();
                    for (int elementPos = 0; elementPos < numberOfTopElement; ++elementPos) {
                        out.add((NumericData)list.get(elementPos));
                    }
                    break;
                }
                case 13: {
                    isSingleValue = false;
                    NumberFunctionArgument argument = (NumberFunctionArgument)aggregationFunctionArguments.get(1);
                    int numberOfBottomElement = list.size() < (int)argument.getDoubleValue() ? list.size() : (int)argument.getDoubleValue();
                    for (int elementPos = 0; elementPos < numberOfBottomElement; ++elementPos) {
                        out.add((NumericData)list.get(list.size() - 1 - elementPos));
                    }
                    break;
                }
                case 14: 
                case 15: {
                    int maxCount = 0;
                    for (NumericData rnm : list) {
                        int count = 0;
                        for (NumericData rnm2 : list) {
                            if (rnm.getValue() != rnm2.getValue()) continue;
                            ++count;
                        }
                        if (count <= maxCount) continue;
                        maxCount = count;
                        retVal = rnm.getValue();
                    }
                    break;
                }
                case 16: {
                    double meanValue = 0.0;
                    double sd = 0.0;
                    for (NumericData rnm : list) {
                        meanValue += rnm.getValue();
                    }
                    meanValue /= (double)size;
                    for (NumericData rnm : list) {
                        sd += Math.pow(rnm.getValue() - meanValue, 2.0) / (double)(size - 1);
                    }
                    retVal = Math.sqrt(sd);
                    break;
                }
                default: {
                    LOG.warn("Mapping of '{}' function not yet supported", (Object)function);
                }
            }
            if (!isSingleValue) continue;
            out.add(new NumericData(firstElementInList.getTimestamp(), retVal));
        }
        return out;
    }

    private double quantil(List<NumericData> in, double val) {
        int n = in.size();
        ArrayList<Double> bla = new ArrayList<Double>(n);
        for (NumericData rnm : in) {
            bla.add(rnm.getValue());
        }
        Collections.sort(bla);
        float x = (float)((double)n * (val / 100.0));
        if (Math.floor(x) == (double)x) {
            return 0.5 * ((Double)bla.get((int)x - 1) + (Double)bla.get((int)x));
        }
        return (Double)bla.get((int)Math.ceil(x - 1.0f));
    }
}

