/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs;

import com.google.common.util.concurrent.FutureCallback;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.api.jaxrs.util.Eager;
import org.hawkular.metrics.core.api.MetricsService;
import org.hawkular.metrics.core.impl.cassandra.CassandraSession;
import org.hawkular.metrics.core.impl.cassandra.MetricsServiceCassandra;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Eager
public class MetricsServiceProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsServiceProducer.class);
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_CQL_PORT)
    private String cqlPort;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_NODES)
    private String nodes;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_KEYSPACE)
    private String keyspace;
    @Produces
    private MetricsService metricsService;
    private CassandraSession cassandraSession;

    @PostConstruct
    void init() {
        LOG.info("Initializing metrics service");
        this.metricsService = new MetricsServiceCassandra();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cqlport", this.cqlPort);
        options.put("nodes", this.nodes);
        options.put("keyspace", this.keyspace);
        CassandraSession.Builder cassandraSessionBuilder = new CassandraSession.Builder();
        cassandraSessionBuilder.withOptions(options);
        cassandraSessionBuilder.withInitializationCallback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.cassandraSession = cassandraSessionBuilder.build();
    }

    @PreDestroy
    void destroy() {
        this.metricsService.shutdown();
        this.cassandraSession.shutdown();
    }

    static /* synthetic */ MetricsService access$000(MetricsServiceProducer x0) {
        return x0.metricsService;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }
}

