/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.filter;

import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.hawkular.metrics.api.jaxrs.ApiError;
import org.hawkular.metrics.core.api.MetricsService;

@Provider
public class MetricsServiceStateFilter
implements ContainerRequestFilter {
    private static final String STARTING = "Service unavailable while initializing.";
    private static final String FAILED = "Internal server error.";
    private static final String STOPPED = "The service is no longer running.";
    @Inject
    private MetricsService metricsService;

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        UriInfo uriInfo = containerRequestContext.getUriInfo();
        String path = uriInfo.getPath();
        if (path.startsWith("/status")) {
            return;
        }
        if (this.metricsService.getState() == MetricsService.State.STARTING) {
            Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(STARTING)).build();
            containerRequestContext.abortWith(response);
        } else if (this.metricsService.getState() == MetricsService.State.FAILED) {
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(FAILED)).build();
            containerRequestContext.abortWith(response);
        } else if (this.metricsService.getState() == MetricsService.State.STOPPED || this.metricsService.getState() == MetricsService.State.STOPPING) {
            Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(STOPPED)).build();
            containerRequestContext.abortWith(response);
        }
    }
}

