/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.api.jaxrs.ApiError;
import org.hawkular.metrics.api.jaxrs.request.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.request.MixedMetricsRequest;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;

@Path(value="/metrics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="", description="Metrics related REST interface")
public class MetricHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @GET
    @Path(value="/")
    @ApiOperation(value="Find tenant's metric definitions.", notes="Does not include any metric values. ", response=List.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved at least one metric definition."), @ApiResponse(code=204, message="No metrics found."), @ApiResponse(code=400, message="Given type is not a valid type.", response=ApiError.class), @ApiResponse(code=500, message="Failed to retrieve metrics due to unexpected error.", response=ApiError.class)})
    public void findMetrics(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Queried metric type", required=true, allowableValues="[gauge, availability, counter]") @QueryParam(value="type") String type) {
        try {
            this.metricsService.findMetrics(this.tenantId, MetricType.fromTextCode((String)type)).map(MetricDefinition::new).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        }
        catch (IllegalArgumentException e) {
            ApiError error = new ApiError("[" + type + "] is not a valid type. Accepted values are gauge|avail|log");
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
        }
    }

    @POST
    @Path(value="/data")
    @ApiOperation(value="Add data for multiple metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addMetricsData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) MixedMetricsRequest metricsRequest) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            if (!(metricsRequest.getGaugeMetrics() != null && metricsRequest.getGaugeMetrics().isEmpty() || metricsRequest.getAvailabilityMetrics() != null && !metricsRequest.getAvailabilityMetrics().isEmpty())) {
                return Futures.immediateFuture((Object)Response.ok().build());
            }
            ArrayList simpleFuturesList = new ArrayList();
            return Futures.transform((ListenableFuture)Futures.successfulAsList(simpleFuturesList), (Function)ApiUtils.MAP_LIST_VOID);
        });
    }
}

