/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.hawkular.metrics.api.jaxrs.influx.InfluxObject;
import org.hawkular.metrics.api.jaxrs.influx.InfluxSeriesHandler;
import org.hawkular.metrics.api.jaxrs.influx.query.InfluxQueryParseTreeWalker;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.InfluxQueryParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.InfluxQueryParserFactory;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.QueryParseException;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.AggregatedColumnDefinition;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.BooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.ColumnDefinition;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.FunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.GroupByClause;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.InfluxTimeUnit;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.ListSeriesDefinitionsParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.NumberFunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.RegularExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitions;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitionsParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.type.QueryType;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.type.QueryTypeVisitor;
import org.hawkular.metrics.api.jaxrs.influx.query.translate.ToIntervalTranslator;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.AggregationFunction;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.IllegalQueryException;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.QueryValidator;
import org.hawkular.metrics.api.jaxrs.influx.write.validation.InfluxObjectValidator;
import org.hawkular.metrics.api.jaxrs.influx.write.validation.InvalidObjectException;
import org.hawkular.metrics.core.api.DataPoint;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/db/{tenantId}/series")
@Produces(value={"application/json"})
@ApplicationScoped
public class InfluxSeriesHandler {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxSeriesHandler.class);
    @Inject
    MetricsService metricsService;
    @Inject
    InfluxObjectValidator objectValidator;
    @Inject
    @InfluxQueryParseTreeWalker
    ParseTreeWalker parseTreeWalker;
    @Inject
    InfluxQueryParserFactory parserFactory;
    @Inject
    QueryValidator queryValidator;
    @Inject
    ToIntervalTranslator toIntervalTranslator;

    @POST
    @Consumes(value={"application/json"})
    public void write(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, List<InfluxObject> influxObjects) {
        if (influxObjects == null) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Null objects"));
            return;
        }
        try {
            this.objectValidator.validateInfluxObjects(influxObjects);
        }
        catch (InvalidObjectException e) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, Throwables.getRootCause((Throwable)e).getMessage()));
            return;
        }
        Observable input = Observable.from(influxObjects).map(influxObject -> InfluxSeriesHandler.influxToGauge((String)tenantId, (InfluxObject)influxObject));
        this.metricsService.addGaugeData(input).subscribe((Observer)new WriteObserver(this, asyncResponse));
    }

    private static Metric<Double> influxToGauge(String tenantId, InfluxObject influxObject) {
        List influxObjectColumns = influxObject.getColumns();
        int valueColumnIndex = influxObjectColumns.indexOf("value");
        List influxObjectPoints = influxObject.getPoints();
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>();
        for (List point : influxObjectPoints) {
            double value;
            long timestamp;
            if (influxObjectColumns.size() == 1) {
                timestamp = System.currentTimeMillis();
                value = ((Number)point.get(0)).doubleValue();
            } else {
                timestamp = ((Number)point.get((valueColumnIndex + 1) % 2)).longValue();
                value = ((Number)point.get(valueColumnIndex)).doubleValue();
            }
            dataPoints.add(new DataPoint(timestamp, (Object)value));
        }
        return new Metric(tenantId, MetricType.GAUGE, new MetricId(influxObject.getName()), dataPoints);
    }

    @GET
    public void query(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @QueryParam(value="q") String queryString) {
        QueryType queryType;
        InfluxQueryParser.QueryContext queryContext;
        if (queryString == null || queryString.isEmpty()) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Missing query"));
            return;
        }
        InfluxQueryParser queryParser = this.parserFactory.newInstanceForQuery(queryString);
        try {
            queryContext = queryParser.query();
            queryType = (QueryType)new QueryTypeVisitor().visit((ParseTree)queryContext);
        }
        catch (QueryParseException e) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Syntactically incorrect query: " + e.getMessage()));
            return;
        }
        switch (1.$SwitchMap$org$hawkular$metrics$api$jaxrs$influx$query$parse$type$QueryType[queryType.ordinal()]) {
            case 1: {
                this.listSeries(asyncResponse, tenantId, queryContext.listSeries());
                break;
            }
            case 2: {
                this.select(asyncResponse, tenantId, queryContext.selectQuery());
                break;
            }
            default: {
                asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Query not yet supported: " + queryString));
            }
        }
    }

    private void listSeries(AsyncResponse asyncResponse, String tenantId, InfluxQueryParser.ListSeriesContext listSeriesContext) {
        Pattern pattern;
        ListSeriesDefinitionsParser definitionsParser = new ListSeriesDefinitionsParser();
        this.parseTreeWalker.walk((ParseTreeListener)definitionsParser, (ParseTree)listSeriesContext);
        RegularExpression regularExpression = definitionsParser.getRegularExpression();
        if (regularExpression != null) {
            int flag = regularExpression.isCaseSensitive() ? 0 : 2;
            try {
                pattern = Pattern.compile(regularExpression.getExpression(), flag);
            }
            catch (Exception e) {
                asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, Throwables.getRootCause((Throwable)e).getMessage()));
                return;
            }
        } else {
            pattern = null;
        }
        this.metricsService.findMetrics(tenantId, MetricType.GAUGE).map(metric -> metric.getId().getName()).filter(name -> pattern == null || pattern.matcher((CharSequence)name).find()).toList().map(InfluxSeriesHandler::metricsListToListSeries).subscribe((Observer)new ReadObserver(this, asyncResponse));
    }

    private static List<InfluxObject> metricsListToListSeries(List<String> metrics) {
        ImmutableList columns = ImmutableList.of((Object)"time", (Object)"name");
        InfluxObject.Builder builder = new InfluxObject.Builder("list_series_result", (List)columns).withForeseenPoints(metrics.size());
        for (String metric : metrics) {
            builder.addPoint((List)ImmutableList.of((Object)0, (Object)metric));
        }
        return ImmutableList.of((Object)builder.createInfluxObject());
    }

    private void select(AsyncResponse asyncResponse, String tenantId, InfluxQueryParser.SelectQueryContext selectQueryContext) {
        SelectQueryDefinitionsParser definitionsParser = new SelectQueryDefinitionsParser();
        this.parseTreeWalker.walk((ParseTreeListener)definitionsParser, (ParseTree)selectQueryContext);
        SelectQueryDefinitions queryDefinitions = definitionsParser.getSelectQueryDefinitions();
        try {
            this.queryValidator.validateSelectQuery(queryDefinitions);
        }
        catch (IllegalQueryException e) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Illegal query: " + e.getMessage()));
            return;
        }
        String metric = queryDefinitions.getFromClause().getName();
        BooleanExpression whereClause = queryDefinitions.getWhereClause();
        Interval timeInterval = whereClause == null ? new Interval((ReadableInstant)new Instant(0L), (ReadableInstant)Instant.now()) : this.toIntervalTranslator.toInterval(whereClause);
        if (timeInterval == null) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Invalid time interval"));
            return;
        }
        String columnName = this.getColumnName(queryDefinitions);
        this.metricsService.idExists(metric).flatMap(idExists -> {
            if (idExists != Boolean.TRUE) {
                return Observable.just(null);
            }
            return this.metricsService.findGaugeData(tenantId, new MetricId(metric), Long.valueOf(timeInterval.getStartMillis()), Long.valueOf(timeInterval.getEndMillis())).toList();
        }).map(metrics -> {
            if (metrics == null) {
                return null;
            }
            if (this.shouldApplyMapping(queryDefinitions)) {
                GroupByClause groupByClause = queryDefinitions.getGroupByClause();
                InfluxTimeUnit bucketSizeUnit = groupByClause.getBucketSizeUnit();
                long bucketSizeSec = bucketSizeUnit.convertTo(TimeUnit.SECONDS, (long)groupByClause.getBucketSize());
                AggregatedColumnDefinition aggregatedColumnDefinition = (AggregatedColumnDefinition)queryDefinitions.getColumnDefinitions().get(0);
                metrics = this.applyMapping(aggregatedColumnDefinition.getAggregationFunction(), aggregatedColumnDefinition.getAggregationFunctionArguments(), metrics, (int)bucketSizeSec, timeInterval.getStartMillis(), timeInterval.getEndMillis());
            }
            if (!queryDefinitions.isOrderDesc()) {
                metrics = Lists.reverse((List)metrics);
            }
            if (queryDefinitions.getLimitClause() != null) {
                metrics = metrics.subList(0, queryDefinitions.getLimitClause().getLimit());
            }
            ArrayList<InfluxObject> objects = new ArrayList<InfluxObject>(1);
            ArrayList<String> columns = new ArrayList<String>(2);
            columns.add("time");
            columns.add(columnName);
            InfluxObject.Builder builder = new InfluxObject.Builder(metric, columns).withForeseenPoints(metrics.size());
            for (DataPoint m : metrics) {
                ArrayList<Object> data = new ArrayList<Object>();
                data.add(m.getTimestamp());
                data.add(m.getValue());
                builder.addPoint(data);
            }
            objects.add(builder.createInfluxObject());
            return objects;
        }).subscribe(objects -> {
            if (objects == null) {
                String msg = "Metric with id [" + metric + "] not found. ";
                asyncResponse.resume((Object)this.errorResponse(Response.Status.NOT_FOUND, msg));
            } else {
                Response.ResponseBuilder builder = Response.ok((Object)objects);
                asyncResponse.resume((Object)builder.build());
            }
        }, arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0));
    }

    private boolean shouldApplyMapping(SelectQueryDefinitions queryDefinitions) {
        return !queryDefinitions.isStarColumn() && queryDefinitions.getColumnDefinitions().get(0) instanceof AggregatedColumnDefinition && queryDefinitions.getGroupByClause() != null;
    }

    private String getColumnName(SelectQueryDefinitions queryDefinitions) {
        if (queryDefinitions.isStarColumn()) {
            return "value";
        }
        return ((ColumnDefinition)queryDefinitions.getColumnDefinitions().get(0)).getDisplayName();
    }

    private List<DataPoint<Double>> applyMapping(String aggregationFunction, List<FunctionArgument> aggregationFunctionArguments, List<DataPoint<Double>> in, int bucketLengthSec, long startTime, long endTime) {
        long timeDiff = endTime - startTime;
        int numBuckets = (int)(timeDiff / 1000L / (long)bucketLengthSec);
        HashMap<Integer, ArrayList<DataPoint<Double>>> tmpMap = new HashMap<Integer, ArrayList<DataPoint<Double>>>(numBuckets);
        for (DataPoint<Double> rnm : in) {
            int pos = (int)((rnm.getTimestamp() - startTime) / 1000L) / bucketLengthSec;
            ArrayList<DataPoint<Double>> bucket = (ArrayList<DataPoint<Double>>)tmpMap.get(pos);
            if (bucket == null) {
                bucket = new ArrayList<DataPoint<Double>>();
                tmpMap.put(pos, bucket);
            }
            bucket.add(rnm);
        }
        ArrayList<DataPoint<Double>> out = new ArrayList<DataPoint<Double>>(numBuckets);
        TreeSet keySet = new TreeSet(tmpMap.keySet());
        for (Integer pos : keySet) {
            List list = (List)tmpMap.get(pos);
            double retVal = 0.0;
            boolean isSingleValue = true;
            if (list == null) continue;
            int size = list.size();
            DataPoint lastElementInList = (DataPoint)list.get(size - 1);
            DataPoint firstElementInList = (DataPoint)list.get(0);
            AggregationFunction function = AggregationFunction.findByName((String)aggregationFunction);
            switch (1.$SwitchMap$org$hawkular$metrics$api$jaxrs$influx$query$validation$AggregationFunction[function.ordinal()]) {
                case 1: {
                    for (DataPoint rnm : list) {
                        retVal += ((Double)rnm.getValue()).doubleValue();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Applying mean mapping, total = {}, size = {}", (Object)retVal, (Object)size);
                    }
                    retVal /= (double)size;
                    break;
                }
                case 2: {
                    retVal = Double.MIN_VALUE;
                    for (DataPoint rnm : list) {
                        if (!((Double)rnm.getValue() > retVal)) continue;
                        retVal = (Double)rnm.getValue();
                    }
                    break;
                }
                case 3: {
                    retVal = Double.MAX_VALUE;
                    for (DataPoint rnm : list) {
                        if (!((Double)rnm.getValue() < retVal)) continue;
                        retVal = (Double)rnm.getValue();
                    }
                    break;
                }
                case 4: {
                    for (DataPoint rnm : list) {
                        retVal += ((Double)rnm.getValue()).doubleValue();
                    }
                    break;
                }
                case 5: {
                    retVal = size;
                    break;
                }
                case 6: {
                    if (list.isEmpty()) break;
                    retVal = (Double)firstElementInList.getValue();
                    break;
                }
                case 7: {
                    if (list.isEmpty()) break;
                    retVal = (Double)lastElementInList.getValue();
                    break;
                }
                case 8: {
                    if (list.isEmpty()) break;
                    retVal = (Double)lastElementInList.getValue() - (Double)firstElementInList.getValue();
                    break;
                }
                case 9: {
                    if (list.isEmpty()) break;
                    double y = (Double)lastElementInList.getValue() - (Double)firstElementInList.getValue();
                    long t = (lastElementInList.getTimestamp() - firstElementInList.getTimestamp()) / 1000L;
                    retVal = y / (double)t;
                    break;
                }
                case 10: {
                    retVal = this.quantil(list, 50.0);
                    break;
                }
                case 11: {
                    NumberFunctionArgument argument = (NumberFunctionArgument)aggregationFunctionArguments.get(1);
                    retVal = this.quantil(list, argument.getDoubleValue());
                    break;
                }
                case 12: {
                    isSingleValue = false;
                    NumberFunctionArgument argument = (NumberFunctionArgument)aggregationFunctionArguments.get(1);
                    int numberOfTopElement = list.size() < (int)argument.getDoubleValue() ? list.size() : (int)argument.getDoubleValue();
                    for (int elementPos = 0; elementPos < numberOfTopElement; ++elementPos) {
                        out.add((DataPoint<Double>)list.get(elementPos));
                    }
                    break;
                }
                case 13: {
                    isSingleValue = false;
                    NumberFunctionArgument argument = (NumberFunctionArgument)aggregationFunctionArguments.get(1);
                    int numberOfBottomElement = list.size() < (int)argument.getDoubleValue() ? list.size() : (int)argument.getDoubleValue();
                    for (int elementPos = 0; elementPos < numberOfBottomElement; ++elementPos) {
                        out.add((DataPoint<Double>)list.get(list.size() - 1 - elementPos));
                    }
                    break;
                }
                case 14: 
                case 15: {
                    int maxCount = 0;
                    for (DataPoint rnm : list) {
                        int count = 0;
                        for (DataPoint rnm2 : list) {
                            if (rnm.getValue() != rnm2.getValue()) continue;
                            ++count;
                        }
                        if (count <= maxCount) continue;
                        maxCount = count;
                        retVal = (Double)rnm.getValue();
                    }
                    break;
                }
                case 16: {
                    double meanValue = 0.0;
                    double sd = 0.0;
                    for (DataPoint rnm : list) {
                        meanValue += ((Double)rnm.getValue()).doubleValue();
                    }
                    meanValue /= (double)size;
                    for (DataPoint rnm : list) {
                        sd += Math.pow((Double)rnm.getValue() - meanValue, 2.0) / (double)(size - 1);
                    }
                    retVal = Math.sqrt(sd);
                    break;
                }
                default: {
                    LOG.warn("Mapping of '{}' function not yet supported", (Object)function);
                }
            }
            if (!isSingleValue) continue;
            out.add((DataPoint<Double>)new DataPoint(firstElementInList.getTimestamp(), (Object)retVal));
        }
        return out;
    }

    private double quantil(List<DataPoint<Double>> in, double val) {
        int n = in.size();
        ArrayList bla = new ArrayList(n);
        bla.addAll(in.stream().map(DataPoint::getValue).sorted().collect(Collectors.toList()));
        float x = (float)((double)n * (val / 100.0));
        if (Math.floor(x) == (double)x) {
            return 0.5 * ((Double)bla.get((int)x - 1) + (Double)bla.get((int)x));
        }
        return (Double)bla.get((int)Math.ceil(x - 1.0f));
    }

    private Response errorResponse(Response.Status status, String message) {
        return Response.status((Response.Status)status).entity((Object)message).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    static /* synthetic */ Response access$000(InfluxSeriesHandler x0, Response.Status x1, String x2) {
        return x0.errorResponse(x1, x2);
    }
}

