/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx.write.validation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.math.BigDecimal;
import java.util.List;
import java.util.ListIterator;
import org.hawkular.metrics.api.jaxrs.influx.InfluxObject;
import org.hawkular.metrics.api.jaxrs.influx.write.validation.InfluxObjectValidationRule;
import org.hawkular.metrics.api.jaxrs.influx.write.validation.InvalidObjectException;

public class DataTypesRule
implements InfluxObjectValidationRule {
    private static final Predicate<Object> IS_INTEGRAL = Predicates.and((Predicate)Predicates.instanceOf(Number.class), (Predicate)Predicates.not((Predicate)Predicates.or((Predicate[])new Predicate[]{Predicates.instanceOf(BigDecimal.class), Predicates.instanceOf(Double.class), Predicates.instanceOf(Float.class)})));

    public void checkInfluxObject(InfluxObject influxObject) throws InvalidObjectException {
        List points = influxObject.getPoints();
        if (points == null) {
            return;
        }
        List columns = influxObject.getColumns();
        for (List point : points) {
            if (point.size() < columns.size()) {
                throw new InvalidObjectException("Object has not enough data in point to match columns");
            }
            if (columns.size() == 1) {
                if (point.get(0) instanceof Number) continue;
                throw new InvalidObjectException("Point 'value' is not numerical");
            }
            int valueIndex = columns.indexOf("value");
            ListIterator dataIterator = point.listIterator();
            while (dataIterator.hasNext()) {
                Object data = dataIterator.next();
                if (valueIndex == dataIterator.nextIndex() - 1) {
                    if (data instanceof Number) continue;
                    throw new InvalidObjectException("Point 'value' is not numerical");
                }
                if (IS_INTEGRAL.apply(data)) continue;
                throw new InvalidObjectException("Point 'time' is not integral");
            }
        }
    }
}

