/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs;

import com.codahale.metrics.MetricRegistry;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.hawkular.metrics.api.jaxrs.MetricsServiceLifecycle;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.api.jaxrs.util.Eager;
import org.hawkular.metrics.core.api.MetricsService;
import org.hawkular.metrics.core.impl.GenerateRate;
import org.hawkular.metrics.core.impl.MetricsServiceImpl;
import org.hawkular.metrics.core.impl.TaskTypes;
import org.hawkular.metrics.schema.SchemaManager;
import org.hawkular.metrics.tasks.api.TaskService;
import org.hawkular.metrics.tasks.api.TaskServiceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action1;

@ApplicationScoped
@Eager
public class MetricsServiceLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsServiceLifecycle.class);
    private MetricsServiceImpl metricsService;
    private TaskService taskService;
    private final ScheduledExecutorService lifecycleExecutor;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_CQL_PORT)
    private String cqlPort;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_NODES)
    private String nodes;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_KEYSPACE)
    private String keyspace;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_RESETDB)
    private String resetDb;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.WAIT_FOR_SERVICE)
    private String waitForService;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.TASK_SCHEDULER_TIME_UNITS)
    private String timeUnits;
    private volatile State state;
    private int connectionAttempts;
    private Session session;

    MetricsServiceLifecycle() {
        ThreadFactory threadFactory = r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName(MetricsService.class.getSimpleName().toLowerCase(Locale.ROOT) + "-lifecycle-thread");
            return thread;
        };
        this.lifecycleExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.state = State.STARTING;
    }

    public State getState() {
        return this.state;
    }

    @PostConstruct
    void init() {
        this.lifecycleExecutor.submit(() -> this.startMetricsService());
        if (Boolean.parseBoolean(this.waitForService) || "embedded_cassandra".equals(System.getProperty("hawkular.backend"))) {
            long start = System.nanoTime();
            while (this.state == State.STARTING && TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MINUTES) > System.nanoTime() - start) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMetricsService() {
        if (this.state != State.STARTING) {
            return;
        }
        LOG.info("Initializing metrics service");
        ++this.connectionAttempts;
        try {
            this.session = this.createSession();
        }
        catch (Exception t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            LOG.warn("Could not connect to Cassandra cluster - assuming its not up yet", rootCause);
            long delay = 1L + ((long)this.connectionAttempts - 1L) % 4L;
            LOG.warn("[{}] Retrying connecting to Cassandra cluster in [{}]s...", (Object)this.connectionAttempts, (Object)delay);
            this.lifecycleExecutor.schedule(() -> this.startMetricsService(), delay, TimeUnit.SECONDS);
            return;
        }
        try {
            this.initSchema();
            this.initTaskService();
            this.metricsService = new MetricsServiceImpl();
            this.metricsService.setTaskService(this.taskService);
            this.taskService.subscribe(TaskTypes.COMPUTE_RATE, (Action1)new GenerateRate((MetricsService)this.metricsService));
            this.metricsService.startUp(this.session, this.keyspace, false, false, new MetricRegistry());
            LOG.info("Metrics service started");
            this.state = State.STARTED;
        }
        catch (Exception t) {
            LOG.error("An error occurred trying to connect to the Cassandra cluster", (Throwable)t);
            this.state = State.FAILED;
        }
        finally {
            if (this.state != State.STARTED) {
                try {
                    this.metricsService.shutdown();
                }
                catch (Exception ignore) {
                    LOG.error("Could not shutdown the metricsService instance: ", (Throwable)ignore);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session createSession() {
        int port;
        Cluster.Builder clusterBuilder = new Cluster.Builder();
        try {
            port = Integer.parseInt(this.cqlPort);
        }
        catch (NumberFormatException nfe) {
            String defaultPort = ConfigurationKey.CASSANDRA_CQL_PORT.defaultValue();
            LOG.warn("Invalid CQL port '{}', not a number. Will use a default of {}", (Object)this.cqlPort, (Object)defaultPort);
            port = Integer.parseInt(defaultPort);
        }
        clusterBuilder.withPort(port);
        Arrays.stream(this.nodes.split(",")).forEach(arg_0 -> ((Cluster.Builder)clusterBuilder).addContactPoint(arg_0));
        Cluster cluster = null;
        Session createdSession = null;
        try {
            cluster = clusterBuilder.build();
            Session session = createdSession = cluster.connect("system");
            return session;
        }
        finally {
            if (createdSession == null && cluster != null) {
                cluster.close();
            }
        }
    }

    private void initSchema() {
        SchemaManager schemaManager = new SchemaManager(this.session);
        if (Boolean.parseBoolean(this.resetDb)) {
            schemaManager.dropKeyspace(this.keyspace);
        }
        schemaManager.createSchema(this.keyspace);
        this.session.execute("USE " + this.keyspace);
    }

    private void initTaskService() {
        LOG.info("Initializing {}", (Object)TaskService.class.getSimpleName());
        this.taskService = new TaskServiceBuilder().withSession(this.session).withTimeUnit(this.getTimeUnit()).withTaskTypes(Collections.singletonList(TaskTypes.COMPUTE_RATE)).build();
        this.taskService.start();
    }

    private TimeUnit getTimeUnit() {
        if ("seconds".equals(this.timeUnits)) {
            return TimeUnit.SECONDS;
        }
        return TimeUnit.MINUTES;
    }

    @Produces
    @ApplicationScoped
    public MetricsService getMetricsService() {
        return this.metricsService;
    }

    @PreDestroy
    void destroy() {
        Future<?> stopFuture = this.lifecycleExecutor.submit(() -> this.stopMetricsService());
        try {
            Futures.get(stopFuture, (long)1L, (TimeUnit)TimeUnit.MINUTES, Exception.class);
        }
        catch (Exception ignore) {
            LOG.error("Unexcepted exception while shutting down, ", (Throwable)ignore);
        }
        this.lifecycleExecutor.shutdown();
    }

    private void stopMetricsService() {
        this.state = State.STOPPING;
        this.metricsService.shutdown();
        this.taskService.shutdown();
        if (this.session != null) {
            try {
                this.session.close();
                this.session.getCluster().close();
            }
            finally {
                this.state = State.STOPPED;
            }
        }
    }
}

