/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.filter;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.hawkular.metrics.api.jaxrs.ApiError;

@Provider
public class TenantFilter
implements ContainerRequestFilter {
    public static final String TENANT_HEADER_NAME = "Hawkular-Tenant";
    private static final String MISSING_TENANT_MSG = "Tenant is not specified. Use 'Hawkular-Tenant' header.";

    public void filter(ContainerRequestContext requestContext) throws IOException {
        UriInfo uriInfo = requestContext.getUriInfo();
        String path = uriInfo.getPath();
        if (path.startsWith("/tenants") || path.startsWith("/db") || path.startsWith("/status") || path.equals("/")) {
            return;
        }
        String tenant = (String)requestContext.getHeaders().getFirst((Object)TENANT_HEADER_NAME);
        if (tenant != null && !tenant.trim().isEmpty()) {
            return;
        }
        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(MISSING_TENANT_MSG)).build();
        requestContext.abortWith(response);
    }
}

