/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.ApiError;
import org.hawkular.metrics.api.jaxrs.handler.observer.MetricCreatedObserver;
import org.hawkular.metrics.api.jaxrs.handler.observer.ResultSetObserver;
import org.hawkular.metrics.api.jaxrs.model.Counter;
import org.hawkular.metrics.api.jaxrs.model.CounterDataPoint;
import org.hawkular.metrics.api.jaxrs.model.GaugeDataPoint;
import org.hawkular.metrics.api.jaxrs.request.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;

@Path(value="/counters")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="", description="Counter metrics interface. A counter is a metric whose value are monotonically increasing or decreasing.")
public class CounterHandler {
    private static Logger logger = LoggerFactory.getLogger(CounterHandler.class);
    private static final long EIGHT_HOURS = TimeUnit.MILLISECONDS.convert(8L, TimeUnit.HOURS);
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    @ApiOperation(value="Create counter metric definition. This operation also causes the rate to be calculated and persisted periodically after raw count data is persisted.", notes="Clients are not required to explicitly create a metric before storing data. Doing so however allows clients to prevent naming collisions and to specify tags and data retention.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric definition created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Counter metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric definition creation failed due to an unexpected error", response=ApiError.class)})
    public void createCounter(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) MetricDefinition metricDefinition, @Context UriInfo uriInfo) {
        Metric metric = new Metric(this.tenantId, MetricType.COUNTER, new MetricId(metricDefinition.getId()), metricDefinition.getTags(), metricDefinition.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/counters/{id}").build(new Object[]{metric.getId().getName()});
        this.metricsService.createMetric(metric).subscribe((Observer)new MetricCreatedObserver(asyncResponse, location));
    }

    @GET
    @Path(value="/{id}")
    @ApiOperation(value="Retrieve a counter definition", response=MetricDefinition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's definition was successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics definition is set."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's definition.", response=ApiError.class)})
    public void getCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.findMetric(this.tenantId, MetricType.COUNTER, new MetricId(id)).map(MetricDefinition::new).map(metricDef -> Response.ok((Object)metricDef).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @POST
    @Path(value="/data")
    @ApiOperation(value="Add data points for multiple counters")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data points succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data points", response=ApiError.class)})
    public void addData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) List<Counter> counters) {
        Observable metrics = ApiUtils.requestToCounters((String)this.tenantId, counters);
        Observable observable = this.metricsService.addCounterData(metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/{id}/data")
    @ApiOperation(value="Add data for a single counter")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="List of data points containing timestamp and value", required=true) List<CounterDataPoint> data) {
        Metric metric = new Metric(this.tenantId, MetricType.COUNTER, new MetricId(id), ApiUtils.requestToCounterDataPoints(data));
        Observable observable = this.metricsService.addCounterData(Observable.just((Object)metric));
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @GET
    @Path(value="/{id}/data")
    @ApiOperation(value="Retrieve counter data points.", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="start or end parameter is invalid.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void findCounterData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end) {
        long now = System.currentTimeMillis();
        long startTime = start == null ? now - EIGHT_HOURS : start;
        long endTime = end == null ? now : end;
        this.metricsService.findCounterData(this.tenantId, new MetricId(id), startTime, endTime).map(CounterDataPoint::new).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> {
            logger.warn("Failed to fetch counter data", t);
            ApiUtils.serverError((Throwable)t);
        });
    }

    @GET
    @Path(value="/{id}/rate")
    @ApiOperation(value="Retrieve counter rate data points which are automatically generated on the server side.", notes="Rate data points are only generated for counters that are explicitly created.", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="start or end parameter is invalid.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void findRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end) {
        long now = System.currentTimeMillis();
        long startTime = start == null ? now - EIGHT_HOURS : start;
        long endTime = end == null ? now : end;
        this.metricsService.findRateData(this.tenantId, new MetricId(id), startTime, endTime).map(GaugeDataPoint::new).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> {
            logger.warn("Failed to fetch counter rate data", t);
            ApiUtils.serverError((Throwable)t);
        });
    }
}

