/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.ApiError;
import org.hawkular.metrics.api.jaxrs.handler.observer.TenantCreatedObserver;
import org.hawkular.metrics.api.jaxrs.request.TenantParam;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.MetricsService;
import org.hawkular.metrics.core.api.Tenant;
import rx.Observer;

@Path(value="/tenants")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="/tenants", description="Tenants related REST interface")
public class TenantsHandler {
    @Inject
    private MetricsService metricsService;

    @POST
    @ApiOperation(value="Create a new tenant. ", notes="Clients are not required to create explicitly create a tenant before starting to store metric data. It is recommended to do so however to ensure that there are no tenant id naming collisions and to provide default data retention settings. ")
    @ApiResponses(value={@ApiResponse(code=201, message="Tenant has been succesfully created."), @ApiResponse(code=400, message="Missing or invalid retention properties. ", response=ApiError.class), @ApiResponse(code=409, message="Given tenant id has already been created.", response=ApiError.class), @ApiResponse(code=500, message="An unexpected error occured while trying to create a tenant.", response=ApiError.class)})
    public void createTenant(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) TenantParam params, @Context UriInfo uriInfo) {
        URI location = uriInfo.getBaseUriBuilder().path("/tenants").build(new Object[0]);
        this.metricsService.createTenant(new Tenant(params.getId())).subscribe((Observer)new TenantCreatedObserver(asyncResponse, location));
    }

    @GET
    @ApiOperation(value="Returns a list of tenants.")
    @ApiResponses(value={@ApiResponse(code=200, message="Returned a list of tenants successfully."), @ApiResponse(code=204, message="No tenants were found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching tenants.", response=ApiError.class)})
    public void findTenants(@Suspended AsyncResponse asyncResponse) {
        this.metricsService.getTenants().map(TenantParam::new).toList().subscribe(tenants -> asyncResponse.resume((Object)ApiUtils.collectionToResponse((Collection)tenants)), error -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)error)));
    }
}

