/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx.query.validation;

import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.AndBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.BooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.GtBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.LtBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.Operand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.OperandUtils;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitions;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.IllegalQueryException;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.QueryNotSupportedException;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.SelectQueryValidationRule;

public class SimpleTimeRangesOnlyRule
implements SelectQueryValidationRule {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkQuery(SelectQueryDefinitions queryDefinitions) throws IllegalQueryException {
        BooleanExpression whereClause = queryDefinitions.getWhereClause();
        if (whereClause == null) {
            return;
        }
        if (whereClause instanceof LtBooleanExpression) {
            LtBooleanExpression lt = (LtBooleanExpression)whereClause;
            this.checkOneTimeOperand(lt.getLeftOperand(), lt.getRightOperand());
            this.checkOneDateOrMomentOperand(lt.getLeftOperand(), lt.getRightOperand());
            return;
        } else if (whereClause instanceof GtBooleanExpression) {
            GtBooleanExpression gt = (GtBooleanExpression)whereClause;
            this.checkOneTimeOperand(gt.getLeftOperand(), gt.getRightOperand());
            this.checkOneDateOrMomentOperand(gt.getLeftOperand(), gt.getRightOperand());
            return;
        } else {
            if (!(whereClause instanceof AndBooleanExpression)) throw new QueryNotSupportedException("Not a simple time range restriction");
            AndBooleanExpression and = (AndBooleanExpression)whereClause;
            BooleanExpression left = and.getLeftExpression();
            BooleanExpression right = and.getRightExpression();
            if (left instanceof LtBooleanExpression) {
                LtBooleanExpression lt = (LtBooleanExpression)left;
                this.checkOneTimeOperand(lt.getLeftOperand(), lt.getRightOperand());
                this.checkOneDateOrMomentOperand(lt.getLeftOperand(), lt.getRightOperand());
                if (right instanceof GtBooleanExpression) {
                    GtBooleanExpression gt = (GtBooleanExpression)right;
                    this.checkOneTimeOperand(gt.getLeftOperand(), gt.getRightOperand());
                    this.checkOneDateOrMomentOperand(gt.getLeftOperand(), gt.getRightOperand());
                    this.checkRestrictionIsARange(lt, gt);
                    return;
                } else {
                    if (!(right instanceof LtBooleanExpression)) throw new QueryNotSupportedException("Not a simple time range restriction");
                    LtBooleanExpression lt2 = (LtBooleanExpression)right;
                    this.checkOneTimeOperand(lt2.getLeftOperand(), lt2.getRightOperand());
                    this.checkOneDateOrMomentOperand(lt2.getLeftOperand(), lt2.getRightOperand());
                    this.checkRestrictionIsARange(lt, lt2);
                }
                return;
            } else {
                if (!(left instanceof GtBooleanExpression)) throw new QueryNotSupportedException("Not a simple time range restriction");
                GtBooleanExpression gt = (GtBooleanExpression)left;
                this.checkOneTimeOperand(gt.getLeftOperand(), gt.getRightOperand());
                this.checkOneDateOrMomentOperand(gt.getLeftOperand(), gt.getRightOperand());
                if (right instanceof LtBooleanExpression) {
                    LtBooleanExpression lt = (LtBooleanExpression)right;
                    this.checkOneTimeOperand(lt.getLeftOperand(), lt.getRightOperand());
                    this.checkOneDateOrMomentOperand(lt.getLeftOperand(), lt.getRightOperand());
                    this.checkRestrictionIsARange(lt, gt);
                    return;
                } else {
                    if (!(right instanceof GtBooleanExpression)) throw new QueryNotSupportedException("Not a simple time range restriction");
                    GtBooleanExpression gt2 = (GtBooleanExpression)right;
                    this.checkOneTimeOperand(gt2.getLeftOperand(), gt2.getRightOperand());
                    this.checkOneDateOrMomentOperand(gt2.getLeftOperand(), gt2.getRightOperand());
                    this.checkRestrictionIsARange(gt, gt2);
                }
            }
        }
    }

    private void checkRestrictionIsARange(LtBooleanExpression lt, GtBooleanExpression gt) throws QueryNotSupportedException {
        if (OperandUtils.isTimeOperand((Operand)lt.getLeftOperand()) && OperandUtils.isTimeOperand((Operand)gt.getRightOperand()) || OperandUtils.isTimeOperand((Operand)lt.getRightOperand()) && OperandUtils.isTimeOperand((Operand)gt.getLeftOperand())) {
            throw new QueryNotSupportedException("Not a simple time range restriction");
        }
    }

    private void checkRestrictionIsARange(GtBooleanExpression gt1, GtBooleanExpression gt2) throws QueryNotSupportedException {
        if (OperandUtils.isTimeOperand((Operand)gt1.getLeftOperand()) && OperandUtils.isTimeOperand((Operand)gt2.getLeftOperand()) || OperandUtils.isTimeOperand((Operand)gt1.getRightOperand()) && OperandUtils.isTimeOperand((Operand)gt2.getRightOperand())) {
            throw new QueryNotSupportedException("Not a simple time range restriction");
        }
    }

    private void checkRestrictionIsARange(LtBooleanExpression lt1, LtBooleanExpression lt2) throws QueryNotSupportedException {
        if (OperandUtils.isTimeOperand((Operand)lt1.getLeftOperand()) && OperandUtils.isTimeOperand((Operand)lt2.getLeftOperand()) || OperandUtils.isTimeOperand((Operand)lt1.getRightOperand()) && OperandUtils.isTimeOperand((Operand)lt2.getRightOperand())) {
            throw new QueryNotSupportedException("Not a simple time range restriction");
        }
    }

    private void checkOneTimeOperand(Operand leftOperand, Operand rightOperand) throws QueryNotSupportedException {
        if (OperandUtils.isTimeOperand((Operand)leftOperand) == OperandUtils.isTimeOperand((Operand)rightOperand)) {
            throw new QueryNotSupportedException("Expected exactly one time operand");
        }
    }

    private void checkOneDateOrMomentOperand(Operand leftOperand, Operand rightOperand) throws QueryNotSupportedException {
        if (OperandUtils.isInstantOperand((Operand)leftOperand) == OperandUtils.isInstantOperand((Operand)rightOperand)) {
            throw new QueryNotSupportedException("Expected exactly one time operand");
        }
    }
}

