/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.wordnik.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.hawkular.metrics.core.api.DataPoint;

@ApiModel(description="A timestamp and a value where the value is interpreted as a signed 64 bit integer")
public class CounterDataPoint {
    @JsonProperty
    private long timestamp;
    @JsonProperty
    private Long value;
    @JsonProperty
    private Map<String, String> tags = Collections.emptyMap();

    private CounterDataPoint() {
    }

    public CounterDataPoint(DataPoint<Long> dataPoint) {
        this.timestamp = dataPoint.getTimestamp();
        this.value = (Long)dataPoint.getValue();
        this.tags = dataPoint.getTags();
    }

    public Long getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getTags() {
        return ImmutableMap.copyOf((Map)this.tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterDataPoint that = (CounterDataPoint)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.value);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("value", (Object)this.value).add("tags", (Object)this.tags).toString();
    }
}

