/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wordnik.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.hawkular.metrics.core.api.Metric;

@ApiModel(description="The definition of a metric to create")
public class MetricDefinition {
    @JsonProperty
    private String tenantId;
    @JsonProperty
    private String id;
    @JsonProperty
    private Map<String, String> tags;
    @JsonProperty
    private Integer dataRetention;

    @JsonCreator
    public MetricDefinition(@JsonProperty(value="id") String id, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="dataRetention") Integer dataRetention) {
        this.id = id;
        this.tags = tags == null ? Collections.emptyMap() : Collections.unmodifiableMap(tags);
        this.dataRetention = dataRetention;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Integer getDataRetention() {
        return this.dataRetention;
    }

    public MetricDefinition(Metric metric) {
        this.tenantId = metric.getTenantId();
        this.id = metric.getId().getName();
        this.tags = metric.getTags();
        this.dataRetention = metric.getDataRetention();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDefinition gauge = (MetricDefinition)o;
        return Objects.equals(this.id, gauge.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "MetricDefinition{tenantId='" + this.tenantId + '\'' + ", id='" + this.id + '\'' + ", tags=" + this.tags + ", dataRetention=" + this.dataRetention + '}';
    }
}

