/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs;

import com.codahale.metrics.MetricRegistry;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.hawkular.metrics.api.jaxrs.MetricsServiceLifecycle;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.api.jaxrs.util.Eager;
import org.hawkular.metrics.api.jaxrs.util.VirtualClock;
import org.hawkular.metrics.core.api.MetricsService;
import org.hawkular.metrics.core.impl.DataAccess;
import org.hawkular.metrics.core.impl.DataAccessImpl;
import org.hawkular.metrics.core.impl.DateTimeService;
import org.hawkular.metrics.core.impl.MetricsServiceImpl;
import org.hawkular.metrics.schema.SchemaManager;
import org.hawkular.metrics.tasks.api.AbstractTrigger;
import org.hawkular.metrics.tasks.api.Task2;
import org.hawkular.metrics.tasks.api.TaskScheduler;
import org.hawkular.metrics.tasks.impl.Queries;
import org.hawkular.metrics.tasks.impl.TaskSchedulerImpl;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.hawkular.rx.cassandra.driver.RxSessionImpl;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;
import rx.schedulers.Schedulers;
import rx.schedulers.TestScheduler;

@ApplicationScoped
@Eager
public class MetricsServiceLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsServiceLifecycle.class);
    private MetricsServiceImpl metricsService;
    private TaskScheduler taskScheduler;
    private final ScheduledExecutorService lifecycleExecutor;
    private VirtualClock virtualClock;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_CQL_PORT)
    private String cqlPort;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_NODES)
    private String nodes;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_KEYSPACE)
    private String keyspace;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_RESETDB)
    private String resetDb;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.WAIT_FOR_SERVICE)
    private String waitForService;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.USE_VIRTUAL_CLOCK)
    private String useVirtualClock;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_USESSL)
    private String cassandraUseSSL;
    private volatile State state;
    private int connectionAttempts;
    private Session session;
    private DataAccess dataAcces;
    private Map<? super Action1<Task2>, Subscription> jobs = new HashMap();

    MetricsServiceLifecycle() {
        ThreadFactory threadFactory = r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName(MetricsService.class.getSimpleName().toLowerCase(Locale.ROOT) + "-lifecycle-thread");
            return thread;
        };
        this.lifecycleExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.state = State.STARTING;
    }

    public State getState() {
        return this.state;
    }

    @PostConstruct
    void init() {
        this.lifecycleExecutor.submit(() -> this.startMetricsService());
        if (Boolean.parseBoolean(this.waitForService) || "embedded_cassandra".equals(System.getProperty("hawkular.backend"))) {
            long start = System.nanoTime();
            while (this.state == State.STARTING && TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MINUTES) > System.nanoTime() - start) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMetricsService() {
        if (this.state != State.STARTING) {
            return;
        }
        LOG.info("Initializing metrics service");
        ++this.connectionAttempts;
        try {
            this.session = this.createSession();
        }
        catch (Exception t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            LOG.warn("Could not connect to Cassandra cluster - assuming its not up yet: ", (Object)rootCause.getLocalizedMessage());
            long delay = 1L + ((long)this.connectionAttempts - 1L) % 4L;
            LOG.warn("[{}] Retrying connecting to Cassandra cluster in [{}]s...", (Object)this.connectionAttempts, (Object)delay);
            this.lifecycleExecutor.schedule(() -> this.startMetricsService(), delay, TimeUnit.SECONDS);
            return;
        }
        try {
            this.initSchema();
            this.dataAcces = new DataAccessImpl(this.session);
            this.initTaskScheduler();
            this.metricsService = new MetricsServiceImpl();
            this.metricsService.setDataAccess(this.dataAcces);
            this.metricsService.setTaskScheduler(this.taskScheduler);
            this.metricsService.setDateTimeService(this.createDateTimeService());
            this.metricsService.startUp(this.session, this.keyspace, false, false, new MetricRegistry());
            LOG.info("Metrics service started");
            this.initJobs();
            this.state = State.STARTED;
        }
        catch (Exception t) {
            LOG.error("An error occurred trying to connect to the Cassandra cluster", (Throwable)t);
            this.state = State.FAILED;
        }
        finally {
            if (this.state != State.STARTED) {
                try {
                    this.metricsService.shutdown();
                }
                catch (Exception ignore) {
                    LOG.error("Could not shutdown the metricsService instance: ", (Throwable)ignore);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session createSession() {
        int port;
        Cluster.Builder clusterBuilder = new Cluster.Builder();
        try {
            port = Integer.parseInt(this.cqlPort);
        }
        catch (NumberFormatException nfe) {
            String defaultPort = ConfigurationKey.CASSANDRA_CQL_PORT.defaultValue();
            LOG.warn("Invalid CQL port '{}', not a number. Will use a default of {}", (Object)this.cqlPort, (Object)defaultPort);
            port = Integer.parseInt(defaultPort);
        }
        clusterBuilder.withPort(port);
        Arrays.stream(this.nodes.split(",")).forEach(arg_0 -> ((Cluster.Builder)clusterBuilder).addContactPoint(arg_0));
        if (Boolean.parseBoolean(this.cassandraUseSSL)) {
            clusterBuilder.withSSL();
        }
        Cluster cluster = null;
        Session createdSession = null;
        try {
            cluster = clusterBuilder.build();
            Session session = createdSession = cluster.connect("system");
            return session;
        }
        finally {
            if (createdSession == null && cluster != null) {
                cluster.close();
            }
        }
    }

    private void initSchema() {
        SchemaManager schemaManager = new SchemaManager(this.session);
        if (Boolean.parseBoolean(this.resetDb)) {
            schemaManager.dropKeyspace(this.keyspace);
        }
        schemaManager.createSchema(this.keyspace);
        this.session.execute("USE " + this.keyspace);
    }

    private void initTaskScheduler() {
        this.taskScheduler = new TaskSchedulerImpl((RxSession)new RxSessionImpl(this.session), new Queries(this.session));
        if (Boolean.valueOf(this.useVirtualClock.toLowerCase()).booleanValue()) {
            TestScheduler scheduler = Schedulers.test();
            scheduler.advanceTimeTo(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            this.virtualClock = new VirtualClock(scheduler);
            AbstractTrigger.now = () -> ((TestScheduler)scheduler).now();
            ((TaskSchedulerImpl)this.taskScheduler).setTickScheduler((Scheduler)scheduler);
        }
        this.taskScheduler.start();
    }

    private void initJobs() {
    }

    private DateTimeService createDateTimeService() {
        DateTimeService dateTimeService = new DateTimeService();
        if (Boolean.valueOf(this.useVirtualClock.toLowerCase()).booleanValue()) {
            dateTimeService.now = () -> new DateTime(this.virtualClock.now());
        }
        return dateTimeService;
    }

    @Produces
    @ApplicationScoped
    public MetricsService getMetricsService() {
        return this.metricsService;
    }

    @Produces
    @ApplicationScoped
    public VirtualClock getVirtualClock() {
        return this.virtualClock;
    }

    @Produces
    @ApplicationScoped
    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    @PreDestroy
    void destroy() {
        Future<?> stopFuture = this.lifecycleExecutor.submit(() -> this.stopMetricsService());
        try {
            Futures.get(stopFuture, (long)1L, (TimeUnit)TimeUnit.MINUTES, Exception.class);
        }
        catch (Exception ignore) {
            LOG.error("Unexcepted exception while shutting down, ", (Throwable)ignore);
        }
        this.lifecycleExecutor.shutdown();
    }

    private void stopMetricsService() {
        this.state = State.STOPPING;
        this.metricsService.shutdown();
        this.taskScheduler.shutdown();
        this.jobs.values().forEach(Subscription::unsubscribe);
        if (this.session != null) {
            try {
                this.session.close();
                this.session.getCluster().close();
            }
            finally {
                this.state = State.STOPPED;
            }
        }
    }
}

