/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.ApiError;
import org.hawkular.metrics.api.jaxrs.handler.observer.MetricCreatedObserver;
import org.hawkular.metrics.api.jaxrs.handler.observer.ResultSetObserver;
import org.hawkular.metrics.api.jaxrs.model.Gauge;
import org.hawkular.metrics.api.jaxrs.model.GaugeDataPoint;
import org.hawkular.metrics.api.jaxrs.param.Duration;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.request.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.request.TagRequest;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.Buckets;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import rx.Observable;
import rx.Observer;

@Path(value="/gauges")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="", description="Gauge metrics interface")
public class GaugeHandler {
    private static final long EIGHT_HOURS = TimeUnit.MILLISECONDS.convert(8L, TimeUnit.HOURS);
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    @ApiOperation(value="Create gauge metric definition.", notes="Clients are not required to explicitly create a metric before storing data. Doing so however allows clients to prevent naming collisions and to specify tags and data retention.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric definition created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Gauge metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric definition creation failed due to an unexpected error", response=ApiError.class)})
    public void createGaugeMetric(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) MetricDefinition metricDefinition, @Context UriInfo uriInfo) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.GAUGE, metricDefinition.getId()), metricDefinition.getTags(), metricDefinition.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/gauges/{id}").build(new Object[]{metric.getId().getName()});
        this.metricsService.createMetric(metric).subscribe((Observer)new MetricCreatedObserver(asyncResponse, location));
    }

    @GET
    @Path(value="/{id}")
    @ApiOperation(value="Retrieve single metric definition.", response=MetricDefinition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's definition was successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics definition is set."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's definition.", response=ApiError.class)})
    public void getGaugeMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.findMetric(new MetricId(this.tenantId, MetricType.GAUGE, id)).map(MetricDefinition::new).map(metricDef -> Response.ok((Object)metricDef).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @GET
    @Path(value="/{id}/tags")
    @ApiOperation(value="Retrieve tags associated with the metric definition.", response=String.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics were found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's tags.", response=ApiError.class)})
    public void getGaugeMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.getMetricTags(new MetricId(this.tenantId, MetricType.GAUGE, id)).subscribe(optional -> asyncResponse.resume((Object)ApiUtils.valueToResponse((Optional)optional)), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @PUT
    @Path(value="/{id}/tags")
    @ApiOperation(value="Update tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully updated."), @ApiResponse(code=500, message="Unexpected error occurred while updating metric's tags.", response=ApiError.class)})
    public void updateGaugeMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(required=true) Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.GAUGE, id));
        this.metricsService.addTags(metric, tags).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @DELETE
    @Path(value="/{id}/tags/{tags}")
    @ApiOperation(value="Delete tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully deleted."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while trying to delete metric's tags.", response=ApiError.class)})
    public void deleteGaugeMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Tag list") @PathParam(value="tags") Tags tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.GAUGE, id));
        this.metricsService.deleteTags(metric, tags.getTags()).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/{id}/data")
    @ApiOperation(value="Add data for a single gauge metric.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addDataForMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="List of datapoints containing timestamp and value", required=true) List<GaugeDataPoint> data) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.GAUGE, id), ApiUtils.requestToGaugeDataPoints(data));
        Observable observable = this.metricsService.addGaugeData(Observable.just((Object)metric));
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/data")
    @ApiOperation(value="Add data for multiple gauge metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addGaugeData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) List<Gauge> gauges) {
        Observable metrics = ApiUtils.requestToGauges((String)this.tenantId, gauges);
        Observable observable = this.metricsService.addGaugeData(metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @GET
    @Path(value="/")
    @ApiOperation(value="Find gauge metrics data by their tags.", response=Map.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched data."), @ApiResponse(code=204, message="No matching data found."), @ApiResponse(code=400, message="Missing or invalid tags query", response=ApiError.class), @ApiResponse(code=500, message="Any error in the query.", response=ApiError.class)})
    public void findGaugeDataByTags(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Tag list", required=true) @QueryParam(value="tags") Tags tags) {
        if (tags == null) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Missing tags query")));
        } else {
            this.metricsService.findGaugeDataByTags(this.tenantId, tags.getTags()).subscribe(m -> {
                if (m.isEmpty()) {
                    asyncResponse.resume((Object)Response.noContent().build());
                } else {
                    asyncResponse.resume((Object)Response.ok((Object)m).build());
                }
            }, t -> asyncResponse.resume((Object)Response.serverError().entity((Object)new ApiError(t.getMessage())).build()));
        }
    }

    @GET
    @Path(value="/{id}/data")
    @ApiOperation(value="Retrieve gauge data. When buckets or bucketDuration query parameter is used, the time range between start and end will be divided in buckets of equal duration, and metric statistics will be computed for each bucket.", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void findGaugeData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration) {
        long now = System.currentTimeMillis();
        long startTime = start == null ? now - EIGHT_HOURS : start;
        long endTime = end == null ? now : end;
        MetricId metricId = new MetricId(this.tenantId, MetricType.GAUGE, id);
        if (bucketsCount == null && bucketDuration == null) {
            this.metricsService.findGaugeData(metricId, Long.valueOf(startTime), Long.valueOf(endTime)).map(GaugeDataPoint::new).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        } else if (bucketsCount != null && bucketDuration != null) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Both buckets and bucketDuration parameters are used")));
        } else {
            Buckets buckets;
            try {
                buckets = bucketsCount != null ? Buckets.fromCount((long)startTime, (long)endTime, (int)bucketsCount) : Buckets.fromStep((long)startTime, (long)endTime, (long)bucketDuration.toMillis());
            }
            catch (IllegalArgumentException e) {
                asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Bucket: " + e.getMessage())));
                return;
            }
            this.metricsService.findGaugeStats(metricId, startTime, endTime, buckets).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        }
    }

    @GET
    @Path(value="/{id}/periods")
    @ApiOperation(value="Retrieve periods for which the condition holds true for each consecutive data point.", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched periods."), @ApiResponse(code=204, message="No data was found."), @ApiResponse(code=400, message="Missing or invalid query parameters")})
    public void findPeriods(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours", required=false) @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now", required=false) @QueryParam(value="end") Long end, @ApiParam(value="A threshold against which values are compared", required=true) @QueryParam(value="threshold") double threshold, @ApiParam(value="A comparison operation to perform between values and the threshold. Supported operations include ge, gte, lt, lte, and eq", required=true, allowableValues="[ge, gte, lt, lte, eq, neq]") @QueryParam(value="op") String operator) {
        Predicate<Double> predicate;
        long now = System.currentTimeMillis();
        Long startTime = start;
        Long endTime = end;
        if (start == null) {
            startTime = now - EIGHT_HOURS;
        }
        if (end == null) {
            endTime = now;
        }
        switch (operator) {
            case "lt": {
                predicate = d2 -> d2 < threshold;
                break;
            }
            case "lte": {
                predicate = d2 -> d2 <= threshold;
                break;
            }
            case "eq": {
                predicate = d2 -> d2 == threshold;
                break;
            }
            case "neq": {
                predicate = d2 -> d2 != threshold;
                break;
            }
            case "gt": {
                predicate = d2 -> d2 > threshold;
                break;
            }
            case "gte": {
                predicate = d2 -> d2 >= threshold;
                break;
            }
            default: {
                predicate = null;
            }
        }
        if (predicate == null) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Invalid value for op parameter. Supported values are lt, lte, eq, gt, gte.")));
        } else {
            this.metricsService.getPeriods(new MetricId(this.tenantId, MetricType.GAUGE, id), predicate, startTime.longValue(), endTime.longValue()).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        }
    }

    @GET
    @Path(value="/tags/{tags}")
    @ApiOperation(value="Find metric data with given tags.", response=Map.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Me values fetched successfully"), @ApiResponse(code=204, message="No matching data found."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Any error while fetching data.", response=ApiError.class)})
    public void findTaggedGaugeData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Tag list") @PathParam(value="tags") Tags tags) {
        this.metricsService.findGaugeDataByTags(this.tenantId, tags.getTags()).flatMap(input -> Observable.from(input.entrySet())).toMap(e -> ((MetricId)e.getKey()).getName(), e2 -> (Set)e2.getValue()).subscribe(m -> {
            if (m.isEmpty()) {
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Object)Response.ok((Object)m).build());
            }
        }, t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @POST
    @Path(value="/{id}/tag")
    @ApiOperation(value="Add or update gauge metric's tags.")
    @ApiResponses(value={@ApiResponse(code=200, message="Tags were modified successfully."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Processing tags failed")})
    public void tagGaugeData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(required=true) TagRequest params) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.GAUGE, id));
        Observable resultSetObservable = params.getTimestamp() != null ? this.metricsService.tagGaugeData(metric, params.getTags(), params.getTimestamp().longValue()) : this.metricsService.tagGaugeData(metric, params.getTags(), params.getStart().longValue(), params.getEnd().longValue());
        resultSetObservable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }
}

