/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx.query.translate;

import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import org.hawkular.metrics.api.jaxrs.influx.InfluxTimeUnit;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.AndBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.BooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.GtBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.InstantOperand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.LongOperand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.LtBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.Operand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.OperandUtils;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

@ApplicationScoped
public class ToIntervalTranslator {
    public Interval toInterval(BooleanExpression whereClause) {
        if (whereClause instanceof GtBooleanExpression) {
            return this.getIntervalFromGtExpression((GtBooleanExpression)whereClause);
        }
        if (whereClause instanceof LtBooleanExpression) {
            return this.getIntervalFromLtExpression((LtBooleanExpression)whereClause);
        }
        AndBooleanExpression and = (AndBooleanExpression)whereClause;
        Interval left = and.getLeftExpression() instanceof GtBooleanExpression ? this.getIntervalFromGtExpression((GtBooleanExpression)and.getLeftExpression()) : this.getIntervalFromLtExpression((LtBooleanExpression)and.getLeftExpression());
        Interval right = and.getRightExpression() instanceof GtBooleanExpression ? this.getIntervalFromGtExpression((GtBooleanExpression)and.getRightExpression()) : this.getIntervalFromLtExpression((LtBooleanExpression)and.getRightExpression());
        return left.overlap((ReadableInterval)right);
    }

    private Interval getIntervalFromLtExpression(LtBooleanExpression whereClause) {
        LtBooleanExpression lt = whereClause;
        if (OperandUtils.isTimeOperand((Operand)lt.getLeftOperand())) {
            Instant instant = this.getInstant(lt.getRightOperand());
            return new Interval((ReadableInstant)new Instant(0L), (ReadableInstant)instant);
        }
        Instant instant = this.getInstant(lt.getLeftOperand());
        return new Interval((ReadableInstant)instant, (ReadableInstant)Instant.now());
    }

    private Interval getIntervalFromGtExpression(GtBooleanExpression gt) {
        if (OperandUtils.isTimeOperand((Operand)gt.getLeftOperand())) {
            Instant instant = this.getInstant(gt.getRightOperand());
            return new Interval((ReadableInstant)instant, (ReadableInstant)Instant.now());
        }
        Instant instant = this.getInstant(gt.getLeftOperand());
        return new Interval((ReadableInstant)new Instant(0L), (ReadableInstant)instant);
    }

    private Instant getInstant(Operand operand) {
        if (operand instanceof InstantOperand) {
            InstantOperand instantOperand = (InstantOperand)operand;
            return instantOperand.getInstant();
        }
        LongOperand longOperand = (LongOperand)operand;
        return new Instant(InfluxTimeUnit.MICROSECONDS.convertTo(TimeUnit.MILLISECONDS, longOperand.getValue()));
    }
}

