/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.handler.observer.MetricCreatedObserver;
import org.hawkular.metrics.api.jaxrs.handler.observer.ResultSetObserver;
import org.hawkular.metrics.api.jaxrs.model.ApiError;
import org.hawkular.metrics.api.jaxrs.model.Availability;
import org.hawkular.metrics.api.jaxrs.model.AvailabilityDataPoint;
import org.hawkular.metrics.api.jaxrs.model.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.param.BucketConfig;
import org.hawkular.metrics.api.jaxrs.param.Duration;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.param.TimeRange;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.Buckets;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import rx.Observable;
import rx.Observer;

@Path(value="/availability")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Availability"})
public class AvailabilityHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    @ApiOperation(value="Create availability metric. Same notes as creating gauge metric apply.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Availability metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric creation failed due to an unexpected error", response=ApiError.class)})
    public void createAvailabilityMetric(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) MetricDefinition metricDefinition, @Context UriInfo uriInfo) {
        if (metricDefinition.getType() != null && MetricType.AVAILABILITY != metricDefinition.getType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("MetricDefinition type does not match " + MetricType.AVAILABILITY.getText())));
        }
        URI location = uriInfo.getBaseUriBuilder().path("/availability/{id}").build(new Object[]{metricDefinition.getId()});
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, metricDefinition.getId()), metricDefinition.getTags(), metricDefinition.getDataRetention());
        this.metricsService.createMetric(metric).subscribe((Observer)new MetricCreatedObserver(asyncResponse, location));
    }

    @GET
    @Path(value="/{id}")
    @ApiOperation(value="Retrieve single metric definition.", response=MetricDefinition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's definition was successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics definition is set."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's definition.", response=ApiError.class)})
    public void getAvailabilityMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.findMetric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id)).map(MetricDefinition::new).map(metricDef -> Response.ok((Object)metricDef).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @GET
    @Path(value="/{id}/tags")
    @ApiOperation(value="Retrieve tags associated with the metric definition.", response=String.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics were found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's tags.", response=ApiError.class)})
    public void getMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.getMetricTags(new MetricId(this.tenantId, MetricType.AVAILABILITY, id)).subscribe(optional -> asyncResponse.resume((Object)ApiUtils.valueToResponse((Optional)optional)), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @PUT
    @Path(value="/{id}/tags")
    @ApiOperation(value="Update tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully updated."), @ApiResponse(code=500, message="Unexpected error occurred while updating metric's tags.", response=ApiError.class)})
    public void updateMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(required=true) Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id));
        this.metricsService.addTags(metric, tags).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @DELETE
    @Path(value="/{id}/tags/{tags}")
    @ApiOperation(value="Delete tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully deleted."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while trying to delete metric's tags.", response=ApiError.class)})
    public void deleteMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Tag list") @PathParam(value="tags") Tags tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id));
        this.metricsService.deleteTags(metric, tags.getTags()).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/{id}/data")
    @ApiOperation(value="Add data for a single availability metric.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addAvailabilityForMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="List of availability datapoints", required=true) List<AvailabilityDataPoint> data) {
        Observable metrics = AvailabilityDataPoint.toObservable((String)this.tenantId, (String)id, data);
        Observable observable = this.metricsService.addDataPoints(MetricType.AVAILABILITY, metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/data")
    @ApiOperation(value="Add metric data for multiple availability metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addAvailabilityData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of availability metrics", required=true) List<Availability> availabilities) {
        Observable metrics = Availability.toObservable((String)this.tenantId, availabilities);
        Observable observable = this.metricsService.addDataPoints(MetricType.AVAILABILITY, metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @GET
    @Path(value="/{id}/data")
    @ApiOperation(value="Retrieve availability data.", notes="When buckets or bucketDuration query parameter is used, the time range between start and end will be divided in buckets of equal duration, and availability statistics will be computed for each bucket.", response=AvailabilityDataPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched availability data."), @ApiResponse(code=204, message="No availability data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching availability data.", response=ApiError.class)})
    public void findAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Set to true to return only distinct, contiguous values") @QueryParam(value="distinct") @DefaultValue(value="false") Boolean distinct) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
            return;
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (!bucketConfig.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem())));
            return;
        }
        MetricId metricId = new MetricId(this.tenantId, MetricType.AVAILABILITY, id);
        Buckets buckets = bucketConfig.getBuckets();
        if (buckets == null) {
            this.metricsService.findAvailabilityData(metricId, timeRange.getStart(), timeRange.getEnd(), distinct.booleanValue()).map(AvailabilityDataPoint::new).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        } else {
            this.metricsService.findAvailabilityStats(metricId, timeRange.getStart(), timeRange.getEnd(), buckets).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        }
    }
}

