/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.handler.observer.MetricCreatedObserver;
import org.hawkular.metrics.api.jaxrs.model.ApiError;
import org.hawkular.metrics.api.jaxrs.model.Availability;
import org.hawkular.metrics.api.jaxrs.model.Counter;
import org.hawkular.metrics.api.jaxrs.model.Gauge;
import org.hawkular.metrics.api.jaxrs.model.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.model.MixedMetricsRequest;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.api.jaxrs.util.MetricTypeTextConverter;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import rx.Observable;
import rx.Observer;

@Path(value="/metrics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Metric"})
public class MetricHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    @ApiOperation(value="Create metric.", notes="Clients are not required to explicitly create a metric before storing data. Doing so however allows clients to prevent naming collisions and to specify tags and data retention.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric creation failed due to an unexpected error", response=ApiError.class)})
    public void createMetric(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) MetricDefinition metricDefinition, @Context UriInfo uriInfo) {
        if (metricDefinition.getType() == null || !metricDefinition.getType().isUserType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("MetricDefinition type is invalid")));
        }
        MetricId id = new MetricId(this.tenantId, metricDefinition.getType(), metricDefinition.getId());
        Metric metric = new Metric(id, metricDefinition.getTags(), metricDefinition.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/{type}/{id}").build(new Object[]{MetricTypeTextConverter.getLongForm((MetricType)id.getType()), id.getName()});
        this.metricsService.createMetric(metric).subscribe((Observer)new MetricCreatedObserver(asyncResponse, location));
    }

    @GET
    @Path(value="/")
    @ApiOperation(value="Find tenant's metric definitions.", notes="Does not include any metric values. ", response=MetricDefinition.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved at least one metric definition."), @ApiResponse(code=204, message="No metrics found."), @ApiResponse(code=400, message="Invalid type parameter type.", response=ApiError.class), @ApiResponse(code=500, message="Failed to retrieve metrics due to unexpected error.", response=ApiError.class)})
    public <T> void findMetrics(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Queried metric type", required=false, allowableValues="gauge, availability, counter") @QueryParam(value="type") MetricType<T> metricType, @ApiParam(value="List of tags filters", required=false) @QueryParam(value="tags") Tags tags) {
        if (metricType != null && !metricType.isUserType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Incorrect type param " + metricType.toString())));
            return;
        }
        Observable metricObservable = tags == null ? this.metricsService.findMetrics(this.tenantId, metricType) : this.metricsService.findMetricsWithFilters(this.tenantId, tags.getTags(), metricType);
        metricObservable.map(MetricDefinition::new).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> {
            if (t instanceof PatternSyntaxException) {
                asyncResponse.resume((Object)ApiUtils.badRequest((Throwable)t));
            } else {
                asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t));
            }
        });
    }

    @POST
    @Path(value="/data")
    @ApiOperation(value="Add data for multiple metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addMetricsData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) MixedMetricsRequest metricsRequest) {
        if (metricsRequest.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.emptyPayload());
            return;
        }
        Observable gauges = Gauge.toObservable((String)this.tenantId, (List)metricsRequest.getGauges());
        Observable availabilities = Availability.toObservable((String)this.tenantId, (List)metricsRequest.getAvailabilities());
        Observable counters = Counter.toObservable((String)this.tenantId, (List)metricsRequest.getCounters());
        this.metricsService.addDataPoints(MetricType.GAUGE, gauges).mergeWith(this.metricsService.addDataPoints(MetricType.AVAILABILITY, availabilities)).mergeWith(this.metricsService.addDataPoints(MetricType.COUNTER, counters)).subscribe(aVoid -> {}, t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)), () -> asyncResponse.resume((Object)Response.ok().build()));
    }
}

