/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.config;

import com.google.common.base.Preconditions;

public enum ConfigurationKey {
    ALLOWED_CORS_ORIGINS("hawkular.metrics.allowed-cors-origins", "*", "ALLOWED_CORS_ORIGINS", false),
    ALLOWED_CORS_ACCESS_CONTROL_ALLOW_HEADERS("hawkular.metrics.allowed-cors-access-control-allow-headers", null, " ALLOWED_CORS_ACCESS_CONTROL_ALLOW_HEADERS", false),
    CACHE_CONTROL_HEADER("hawkular.metrics.cache-control-header", "no-cache", " CACHE_CONTROL_HEADER", false),
    CASSANDRA_NODES("hawkular.metrics.cassandra.nodes", "127.0.0.1", "CASSANDRA_NODES", false),
    CASSANDRA_CQL_PORT("hawkular.metrics.cassandra.cql-port", "9042", "CASSANDRA_CQL_PORT", false),
    CASSANDRA_KEYSPACE("hawkular.metrics.cassandra.keyspace", "hawkular_metrics", null, false),
    CASSANDRA_REPLICATION_FACTOR("hawkular.metrics.cassandra.replication-factor", "1", "CASSANDRA_REPLICATION_FACTOR", false),
    CASSANDRA_CLUSTER_CONNECTION_ATTEMPTS("hawkular.metrics.cassandra.cluster.connection-attempts", "5", "CASSANDRA_CLUSTER_CONNECTION_ATTEMPTS", false),
    CASSANDRA_CLUSTER_CONNECTION_MAX_DELAY("hawkular.metrics.cassandra.cluster.connection-delay", "30000", "CASSANDR_CLUSTER_CONNECTION_DELAY", false),
    CASSANDRA_RESETDB("hawkular.metrics.cassandra.resetdb", null, null, true),
    CASSANDRA_USESSL("hawkular.metrics.cassandra.use-ssl", "false", "CASSANDRA_USESSL", false),
    CASSANDRA_MAX_CONN_HOST("hawkular.metrics.cassandra.max-connections-per-host", "10", "CASSANDRA_MAX_CONN_HOST", false),
    CASSANDRA_MAX_REQUEST_CONN("hawkular.metrics.cassandra.max-requests-per-connection", "1024", "CASSANDRA_MAX_REQUEST_CONN", false),
    CASSANDRA_MAX_QUEUE_SIZE("hawkular.metrics.cassandra.max-queue-size", "256", "CASSANDRA_MAX_QUEUE_SIZE", false),
    CASSANDRA_REQUEST_TIMEOUT("hawkular.metrics.cassandra.request-timeout", "12000", "CASSANDRA_REQUEST_TIMEOUT", false),
    CASSANDRA_CONNECTION_TIMEOUT("hawkular.metrics.cassandra.connection-timeout", "5000", "CASSANDRA_CONNECTION_TIMEOUT", false),
    CASSANDRA_SCHEMA_REFRESH_INTERVAL("hawkular.metrics.cassandra.schema.refresh-interval", "1000", "CASSANDRA_SCHEMA_REFRESH_INTERVAL", false),
    PAGE_SIZE("hawkular.metrics.page-size", "1000", "PAGE_SIZE", false),
    COMPRESSION_QUERY_PAGE_SIZE("hawkular.metrics.compression.page-size", "1000", "COMPRESSION_PAGE_SIZE", false),
    COMPRESSION_JOB_ENABLED("hawkular.metrics.jobs.compression.enabled", null, "COMPRESSION_JOB_ENABLED", false),
    WAIT_FOR_SERVICE("hawkular.metrics.waitForService", null, null, true),
    DEFAULT_TTL("hawkular.metrics.default-ttl", "7", "DEFAULT_TTL", false),
    JMX_REPORTING_ENABLED("hawkular.metrics.jmx-reporting-enabled", null, "JMX_REPORTING_ENABLED", true),
    ADMIN_TOKEN("hawkular.metrics.admin-token", null, "ADMIN_TOKEN", false),
    ADMIN_TENANT("hawkular.metrics.admin-tenant", "admin", "ADMIN_TENANT", false),
    METRICS_REPORTING_HOSTNAME("hawkular.metrics.reporting.hostname", null, "METRICS_REPORTING_HOSTNAME", false),
    METRICS_REPORTING_ENABLED("hawkular.metrics.reporting.enabled", null, "METRICS_REPORTING_ENABLED", true),
    METRICS_REPORTING_COLLECTION_INTERVAL("hawkular.metrics.reporting.collection-interval", "300", "METRICS_REPORTING_COLLECTION_INTERVAL", false),
    REQUEST_LOGGING_LEVEL("hawkular.metrics.request.logging.level", null, "REQUEST_LOGGING_LEVEL", false),
    REQUEST_LOGGING_LEVEL_WRITES("hawkular.metrics.request.logging.level.writes", null, "REQUEST_LOGGING_LEVEL_WRITES", false),
    INGEST_MAX_RETRIES("hawkular.metrics.ingestion.retry.max-retries", null, "INGEST_MAX_RETRIES", false),
    INGEST_MAX_RETRY_DELAY("hawkular.metrics.ingestion.retry.max-delay", null, "INGEST_MAX_RETRY_DELAY", false),
    METRICS_PUBLISH_BUFFER_SIZE("hawkular.metrics.publish-buffer-size", "100", "METRICS_PUBLISH_BUFFER_SIZE", false),
    METRICS_PUBLISH_PERIOD("hawkular.metrics.publish-period", "2000", "METRICS_PUBLISH_PERIOD", false),
    DISABLE_METRICS_FORWARDING("hawkular.metrics.disable-metrics-forwarding", null, "DISABLE_METRICS_FORWARDING", true),
    DISABLE_PUBLISH_FILTERING("hawkular.metrics.disable-publish-filtering", null, "DISABLE_PUBLISH_FILTERING", true);

    private final String name;
    private final String env;
    private final String defaultValue;
    private final boolean flag;

    private ConfigurationKey(String name, String defaultValue, String env, boolean flag) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name is null");
        Preconditions.checkArgument((!flag || defaultValue == null ? 1 : 0) != 0, (Object)"Config flags can't have a default value");
        this.name = name;
        this.env = env;
        this.defaultValue = defaultValue;
        this.flag = flag;
    }

    public String toString() {
        return this.name;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String toEnvString() {
        return this.env;
    }

    public boolean isFlag() {
        return this.flag;
    }
}

