/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.security;

import java.io.IOException;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.metrics.model.ApiError;
import org.jboss.logging.Logger;

@Provider
@PreMatching
public class PersonaFilter
implements ContainerRequestFilter {
    private final Logger log = Logger.getLogger(PersonaFilter.class);
    public static final String TENANT_HEADER_NAME = "Hawkular-Tenant";
    public static final String MISSING_TENANT_MSG = "Tenant is not specified. Use 'Hawkular-Tenant' header.";
    public static final String TENANT_HEADER_NOT_ALLOWED = "The Hawkular-Tenant header is not allowed. The tenant is determined from the credentials supplied with the request";
    @Inject
    Instance<Persona> persona;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String path = requestContext.getUriInfo().getPath();
        if (path.startsWith("/db") || path.startsWith("/status") || path.equals("/")) {
            return;
        }
        if (requestContext.getHeaderString(TENANT_HEADER_NAME) != null) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(TENANT_HEADER_NOT_ALLOWED)).build());
        } else if (!this.checkPersona()) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(MISSING_TENANT_MSG)).build());
        } else {
            requestContext.getHeaders().putSingle((Object)TENANT_HEADER_NAME, (Object)((Persona)this.persona.get()).getId());
        }
    }

    private boolean checkPersona() {
        if (this.persona == null) {
            this.log.warn((Object)"Persona is null. Possible issue with accounts integration ? ");
            return false;
        }
        if (this.isEmpty(((Persona)this.persona.get()).getId())) {
            this.log.warn((Object)"Persona is empty. Possible issue with accounts integration ? ");
            return false;
        }
        return true;
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

