/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.log.time;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import javax.servlet.ServletContext;
import org.hawkular.metrics.api.jaxrs.log.time.RequestTimeLogger;

public class TimerLoggerServletExtension
implements ServletExtension {
    private RequestTimeLogger requestTimeLogger;
    private static final String THRESHOLD_PROPERTY_KEY = "hawkular.metrics.request.logging.time.threshold";
    private static final String THRESHOLD_ENV_VAR = "REQUEST_LOGGING_TIME_THRESHOLD";
    private static final long DEFAULT_THRESHOLD_VALUE = 10000L;

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        long timeThreshold = 10000L;
        String thresholdValue = System.getProperty(THRESHOLD_PROPERTY_KEY);
        if (thresholdValue == null) {
            thresholdValue = System.getenv(THRESHOLD_ENV_VAR);
        }
        if (thresholdValue != null && !thresholdValue.isEmpty()) {
            try {
                timeThreshold = Long.parseLong(thresholdValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        long cTimeThreshold = timeThreshold;
        deploymentInfo.addInitialHandlerChainWrapper(containerHandler -> {
            this.requestTimeLogger = new RequestTimeLogger(containerHandler, cTimeThreshold);
            return this.requestTimeLogger;
        });
    }
}

