/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import com.googlecode.concurrentlinkedhashmap.Weigher;
import java.io.IOException;
import java.util.Iterator;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.RefCountedMemory;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.MemoryInputStream;
import org.apache.cassandra.io.util.MemoryOutputStream;
import org.apache.cassandra.utils.vint.EncodedDataInputStream;
import org.apache.cassandra.utils.vint.EncodedDataOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializingCache<K, V>
implements ICache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(SerializingCache.class);
    private static final TypeSizes ENCODED_TYPE_SIZES = TypeSizes.VINT;
    private static final int DEFAULT_CONCURENCY_LEVEL = 64;
    private final ConcurrentLinkedHashMap<K, RefCountedMemory> map;
    private final ISerializer<V> serializer;

    private SerializingCache(long capacity, Weigher<RefCountedMemory> weigher, ISerializer<V> serializer) {
        this.serializer = serializer;
        EvictionListener listener = new EvictionListener<K, RefCountedMemory>(){

            @Override
            public void onEviction(K k, RefCountedMemory mem) {
                mem.unreference();
            }
        };
        this.map = new ConcurrentLinkedHashMap.Builder().weigher(weigher).maximumWeightedCapacity(capacity).concurrencyLevel(64).listener(listener).build();
    }

    public static <K, V> SerializingCache<K, V> create(long weightedCapacity, Weigher<RefCountedMemory> weigher, ISerializer<V> serializer) {
        return new SerializingCache<K, V>(weightedCapacity, weigher, serializer);
    }

    public static <K, V> SerializingCache<K, V> create(long weightedCapacity, ISerializer<V> serializer) {
        return SerializingCache.create(weightedCapacity, new Weigher<RefCountedMemory>(){

            @Override
            public int weightOf(RefCountedMemory value) {
                long size = value.size();
                assert (size < Integer.MAX_VALUE) : "Serialized size cannot be more than 2GB";
                return (int)size;
            }
        }, serializer);
    }

    private V deserialize(RefCountedMemory mem) {
        try {
            return this.serializer.deserialize(new EncodedDataInputStream(new MemoryInputStream(mem)));
        }
        catch (IOException e) {
            logger.trace("Cannot fetch in memory data, we will fallback to read from disk ", e);
            return null;
        }
    }

    private RefCountedMemory serialize(V value) {
        RefCountedMemory freeableMemory;
        long serializedSize = this.serializer.serializedSize(value, ENCODED_TYPE_SIZES);
        if (serializedSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to allocate " + serializedSize + " bytes");
        }
        try {
            freeableMemory = new RefCountedMemory(serializedSize);
        }
        catch (OutOfMemoryError e) {
            return null;
        }
        try {
            this.serializer.serialize(value, new EncodedDataOutputStream(new MemoryOutputStream(freeableMemory)));
        }
        catch (IOException e) {
            freeableMemory.unreference();
            throw new RuntimeException(e);
        }
        return freeableMemory;
    }

    @Override
    public long capacity() {
        return this.map.capacity();
    }

    @Override
    public void setCapacity(long capacity) {
        this.map.setCapacity(capacity);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public long weightedSize() {
        return this.map.weightedSize();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        RefCountedMemory mem = this.map.get(key);
        if (mem == null) {
            return null;
        }
        if (!mem.reference()) {
            return null;
        }
        try {
            V v = this.deserialize(mem);
            return v;
        }
        finally {
            mem.unreference();
        }
    }

    @Override
    public void put(K key, V value) {
        RefCountedMemory old;
        RefCountedMemory mem = this.serialize(value);
        if (mem == null) {
            return;
        }
        try {
            old = this.map.put(key, mem);
        }
        catch (Throwable t) {
            mem.unreference();
            throw t;
        }
        if (old != null) {
            old.unreference();
        }
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        RefCountedMemory old;
        RefCountedMemory mem = this.serialize(value);
        if (mem == null) {
            return false;
        }
        try {
            old = this.map.putIfAbsent(key, mem);
        }
        catch (Throwable t) {
            mem.unreference();
            throw t;
        }
        if (old != null) {
            mem.unreference();
        }
        return old == null;
    }

    @Override
    public boolean replace(K key, V oldToReplace, V value) {
        boolean success;
        RefCountedMemory old = this.map.get(key);
        if (old == null) {
            return false;
        }
        if (!old.reference()) {
            return false;
        }
        V oldValue = this.deserialize(old);
        old.unreference();
        if (!oldValue.equals(oldToReplace)) {
            return false;
        }
        RefCountedMemory mem = this.serialize(value);
        if (mem == null) {
            return false;
        }
        try {
            success = this.map.replace(key, old, mem);
        }
        catch (Throwable t) {
            mem.unreference();
            throw t;
        }
        if (success) {
            old.unreference();
        } else {
            mem.unreference();
        }
        return success;
    }

    @Override
    public void remove(K key) {
        RefCountedMemory mem = this.map.remove(key);
        if (mem != null) {
            mem.unreference();
        }
    }

    @Override
    public Iterator<K> keyIterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Iterator<K> hotKeyIterator(int n) {
        return this.map.descendingKeySetWithLimit(n).iterator();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }
}

