/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.IndexType;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;

public class ColumnDefinition
extends ColumnSpecification {
    public final Kind kind;
    private String indexName;
    private IndexType indexType;
    private Map<String, String> indexOptions;
    private final Integer componentIndex;

    public static ColumnDefinition partitionKeyDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(cfm, name, validator, componentIndex, Kind.PARTITION_KEY);
    }

    public static ColumnDefinition partitionKeyDef(String ksName, String cfName, ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(ksName, cfName, new ColumnIdentifier(name, UTF8Type.instance), validator, null, null, null, componentIndex, Kind.PARTITION_KEY);
    }

    public static ColumnDefinition clusteringKeyDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(cfm, name, validator, componentIndex, Kind.CLUSTERING_COLUMN);
    }

    public static ColumnDefinition regularDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(cfm, name, validator, componentIndex, Kind.REGULAR);
    }

    public static ColumnDefinition staticDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(cfm, name, validator, componentIndex, Kind.STATIC);
    }

    public static ColumnDefinition compactValueDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> validator) {
        return new ColumnDefinition(cfm, name, validator, null, Kind.COMPACT_VALUE);
    }

    public ColumnDefinition(CFMetaData cfm, ByteBuffer name, AbstractType<?> validator, Integer componentIndex, Kind kind) {
        this(cfm.ksName, cfm.cfName, new ColumnIdentifier(name, cfm.getComponentComparator(componentIndex, kind)), validator, null, null, null, componentIndex, kind);
    }

    @VisibleForTesting
    public ColumnDefinition(String ksName, String cfName, ColumnIdentifier name, AbstractType<?> validator, IndexType indexType, Map<String, String> indexOptions, String indexName, Integer componentIndex, Kind kind) {
        super(ksName, cfName, name, validator);
        assert (name != null && validator != null);
        this.kind = kind;
        this.indexName = indexName;
        this.componentIndex = componentIndex;
        this.setIndexType(indexType, indexOptions);
    }

    public ColumnDefinition copy() {
        return new ColumnDefinition(this.ksName, this.cfName, this.name, this.type, this.indexType, this.indexOptions, this.indexName, this.componentIndex, this.kind);
    }

    public ColumnDefinition withNewName(ColumnIdentifier newName) {
        return new ColumnDefinition(this.ksName, this.cfName, newName, this.type, this.indexType, this.indexOptions, this.indexName, this.componentIndex, this.kind);
    }

    public ColumnDefinition withNewType(AbstractType<?> newType) {
        return new ColumnDefinition(this.ksName, this.cfName, this.name, newType, this.indexType, this.indexOptions, this.indexName, this.componentIndex, this.kind);
    }

    public boolean isOnAllComponents() {
        return this.componentIndex == null;
    }

    public boolean isPartitionKey() {
        return this.kind == Kind.PARTITION_KEY;
    }

    public boolean isClusteringColumn() {
        return this.kind == Kind.CLUSTERING_COLUMN;
    }

    public boolean isStatic() {
        return this.kind == Kind.STATIC;
    }

    public boolean isRegular() {
        return this.kind == Kind.REGULAR;
    }

    public boolean isCompactValue() {
        return this.kind == Kind.COMPACT_VALUE;
    }

    public int position() {
        return this.componentIndex == null ? 0 : this.componentIndex;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition cd = (ColumnDefinition)o;
        return Objects.equal(this.ksName, cd.ksName) && Objects.equal(this.cfName, cd.cfName) && Objects.equal(this.name, cd.name) && Objects.equal(this.type, cd.type) && Objects.equal((Object)this.kind, (Object)cd.kind) && Objects.equal(this.componentIndex, cd.componentIndex) && Objects.equal(this.indexName, cd.indexName) && Objects.equal((Object)this.indexType, (Object)cd.indexType) && Objects.equal(this.indexOptions, cd.indexOptions);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(new Object[]{this.ksName, this.cfName, this.name, this.type, this.kind, this.componentIndex, this.indexName, this.indexType, this.indexOptions});
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this).add("name", this.name).add("type", this.type).add("kind", (Object)this.kind).add("componentIndex", this.componentIndex).add("indexName", this.indexName).add("indexType", (Object)this.indexType).toString();
    }

    public boolean isThriftCompatible() {
        return this.kind == Kind.REGULAR && this.componentIndex == null;
    }

    public boolean isPrimaryKeyColumn() {
        return this.kind == Kind.PARTITION_KEY || this.kind == Kind.CLUSTERING_COLUMN;
    }

    public boolean isPartOfCellName() {
        return this.kind == Kind.REGULAR || this.kind == Kind.STATIC;
    }

    public ColumnDefinition apply(ColumnDefinition def) throws ConfigurationException {
        assert (this.kind == def.kind && Objects.equal(this.componentIndex, def.componentIndex));
        if (this.getIndexType() != null && def.getIndexType() != null) {
            if (!def.type.isCompatibleWith(this.type)) {
                throw new ConfigurationException(String.format("Cannot modify validator to a non-order-compatible one for column %s since an index is set", this.name));
            }
            assert (this.getIndexName() != null);
            if (!this.getIndexName().equals(def.getIndexName())) {
                throw new ConfigurationException("Cannot modify index name: " + def.getIndexName());
            }
        }
        return new ColumnDefinition(this.ksName, this.cfName, this.name, def.type, def.getIndexType(), def.getIndexOptions(), def.getIndexName(), this.componentIndex, this.kind);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ColumnDefinition setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public ColumnDefinition setIndexType(IndexType indexType, Map<String, String> indexOptions) {
        this.indexType = indexType;
        this.indexOptions = indexOptions;
        return this;
    }

    public ColumnDefinition setIndex(String indexName, IndexType indexType, Map<String, String> indexOptions) {
        return this.setIndexName(indexName).setIndexType(indexType, indexOptions);
    }

    public boolean isIndexed() {
        return this.indexType != null;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public Map<String, String> getIndexOptions() {
        return this.indexOptions;
    }

    public boolean hasIndexOption(String name) {
        return this.indexOptions != null && this.indexOptions.containsKey(name);
    }

    public static List<ColumnIdentifier> toIdentifiers(List<ColumnDefinition> definitions) {
        return Lists.transform(definitions, new Function<ColumnDefinition, ColumnIdentifier>(){

            @Override
            public ColumnIdentifier apply(ColumnDefinition columnDef) {
                return columnDef.name;
            }
        });
    }

    public static enum Kind {
        PARTITION_KEY,
        CLUSTERING_COLUMN,
        REGULAR,
        STATIC,
        COMPACT_VALUE;

    }
}

