/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.UTMetaData;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;

public final class KSMetaData {
    public final String name;
    public final Class<? extends AbstractReplicationStrategy> strategyClass;
    public final Map<String, String> strategyOptions;
    private final Map<String, CFMetaData> cfMetaData;
    public final boolean durableWrites;
    public final UTMetaData userTypes;

    public KSMetaData(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, boolean durableWrites) {
        this(name, strategyClass, strategyOptions, durableWrites, Collections.emptyList(), new UTMetaData());
    }

    public KSMetaData(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, boolean durableWrites, Iterable<CFMetaData> cfDefs) {
        this(name, strategyClass, strategyOptions, durableWrites, cfDefs, new UTMetaData());
    }

    private KSMetaData(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, boolean durableWrites, Iterable<CFMetaData> cfDefs, UTMetaData userTypes) {
        this.name = name;
        this.strategyClass = strategyClass == null ? NetworkTopologyStrategy.class : strategyClass;
        this.strategyOptions = strategyOptions;
        HashMap<String, CFMetaData> cfmap = new HashMap<String, CFMetaData>();
        for (CFMetaData cfm : cfDefs) {
            cfmap.put(cfm.cfName, cfm);
        }
        this.cfMetaData = Collections.unmodifiableMap(cfmap);
        this.durableWrites = durableWrites;
        this.userTypes = userTypes;
    }

    public static KSMetaData newKeyspace(String name, String strategyName, Map<String, String> options, boolean durableWrites) throws ConfigurationException {
        Class<AbstractReplicationStrategy> cls = AbstractReplicationStrategy.getClass(strategyName);
        if (cls.equals(LocalStrategy.class)) {
            throw new ConfigurationException("Unable to use given strategy class: LocalStrategy is reserved for internal use.");
        }
        return KSMetaData.newKeyspace(name, cls, options, durableWrites, Collections.emptyList());
    }

    public static KSMetaData newKeyspace(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> options, boolean durablesWrites, Iterable<CFMetaData> cfDefs) {
        return new KSMetaData(name, strategyClass, options, durablesWrites, cfDefs, new UTMetaData());
    }

    public KSMetaData cloneWithTableRemoved(CFMetaData table) {
        ArrayList<CFMetaData> newTables = new ArrayList<CFMetaData>(this.cfMetaData().values());
        newTables.remove(table);
        assert (newTables.size() == this.cfMetaData().size() - 1);
        return this.cloneWith(newTables, this.userTypes);
    }

    public KSMetaData cloneWithTableAdded(CFMetaData table) {
        ArrayList<CFMetaData> newTables = new ArrayList<CFMetaData>(this.cfMetaData().values());
        newTables.add(table);
        assert (newTables.size() == this.cfMetaData().size() + 1);
        return this.cloneWith(newTables, this.userTypes);
    }

    public KSMetaData cloneWith(Iterable<CFMetaData> tables, UTMetaData types) {
        return new KSMetaData(this.name, this.strategyClass, this.strategyOptions, this.durableWrites, tables, types);
    }

    public static KSMetaData testMetadata(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, CFMetaData ... cfDefs) {
        return new KSMetaData(name, strategyClass, strategyOptions, true, Arrays.asList(cfDefs));
    }

    public static KSMetaData testMetadataNotDurable(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, CFMetaData ... cfDefs) {
        return new KSMetaData(name, strategyClass, strategyOptions, false, Arrays.asList(cfDefs));
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.strategyClass, this.strategyOptions, this.cfMetaData, this.durableWrites, this.userTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KSMetaData)) {
            return false;
        }
        KSMetaData other = (KSMetaData)o;
        return Objects.equal(this.name, other.name) && Objects.equal(this.strategyClass, other.strategyClass) && Objects.equal(this.strategyOptions, other.strategyOptions) && Objects.equal(this.cfMetaData, other.cfMetaData) && Objects.equal(this.durableWrites, other.durableWrites) && Objects.equal(this.userTypes, other.userTypes);
    }

    public Map<String, CFMetaData> cfMetaData() {
        return this.cfMetaData;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.name).add("strategyClass", this.strategyClass.getSimpleName()).add("strategyOptions", this.strategyOptions).add("cfMetaData", this.cfMetaData).add("durableWrites", this.durableWrites).add("userTypes", this.userTypes).toString();
    }

    public static Map<String, String> optsWithRF(Integer rf) {
        return Collections.singletonMap("replication_factor", rf.toString());
    }

    public KSMetaData validate() throws ConfigurationException {
        if (!CFMetaData.isNameValid(this.name)) {
            throw new ConfigurationException(String.format("Keyspace name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.name));
        }
        TokenMetadata tmd = StorageService.instance.getTokenMetadata();
        IEndpointSnitch eps = DatabaseDescriptor.getEndpointSnitch();
        AbstractReplicationStrategy.validateReplicationStrategy(this.name, this.strategyClass, tmd, eps, this.strategyOptions);
        for (CFMetaData cfm : this.cfMetaData.values()) {
            cfm.validate();
        }
        return this;
    }
}

