/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.AbstractIterator;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.service.pager.QueryPager;

public abstract class UntypedResultSet
implements Iterable<Row> {
    public static UntypedResultSet create(ResultSet rs) {
        return new FromResultSet(rs);
    }

    public static UntypedResultSet create(List<Map<String, ByteBuffer>> results) {
        return new FromResultList(results);
    }

    public static UntypedResultSet create(SelectStatement select, QueryPager pager, int pageSize) {
        return new FromPager(select, pager, pageSize);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract int size();

    public abstract Row one();

    public abstract List<ColumnSpecification> metadata();

    public static class Row {
        private final Map<String, ByteBuffer> data = new HashMap<String, ByteBuffer>();
        private final List<ColumnSpecification> columns = new ArrayList<ColumnSpecification>();

        public Row(Map<String, ByteBuffer> data) {
            this.data.putAll(data);
        }

        public Row(List<ColumnSpecification> names, List<ByteBuffer> columns) {
            this.columns.addAll(names);
            for (int i = 0; i < names.size(); ++i) {
                this.data.put(names.get((int)i).name.toString(), columns.get(i));
            }
        }

        public boolean has(String column) {
            return this.data.get(column) != null;
        }

        public ByteBuffer getBlob(String column) {
            return this.data.get(column);
        }

        public String getString(String column) {
            return (String)UTF8Type.instance.compose(this.data.get(column));
        }

        public boolean getBoolean(String column) {
            return (Boolean)BooleanType.instance.compose(this.data.get(column));
        }

        public byte getByte(String column) {
            return (Byte)ByteType.instance.compose(this.data.get(column));
        }

        public short getShort(String column) {
            return (Short)ShortType.instance.compose(this.data.get(column));
        }

        public int getInt(String column) {
            return (Integer)Int32Type.instance.compose(this.data.get(column));
        }

        public double getDouble(String column) {
            return (Double)DoubleType.instance.compose(this.data.get(column));
        }

        public ByteBuffer getBytes(String column) {
            return this.data.get(column);
        }

        public InetAddress getInetAddress(String column) {
            return (InetAddress)InetAddressType.instance.compose(this.data.get(column));
        }

        public UUID getUUID(String column) {
            return (UUID)UUIDType.instance.compose(this.data.get(column));
        }

        public Date getTimestamp(String column) {
            return (Date)TimestampType.instance.compose(this.data.get(column));
        }

        public long getLong(String column) {
            return (Long)LongType.instance.compose(this.data.get(column));
        }

        public <T> Set<T> getSet(String column, AbstractType<T> type) {
            ByteBuffer raw = this.data.get(column);
            return raw == null ? null : (Set)SetType.getInstance(type, true).compose(raw);
        }

        public <T> List<T> getList(String column, AbstractType<T> type) {
            ByteBuffer raw = this.data.get(column);
            return raw == null ? null : (List)ListType.getInstance(type, true).compose(raw);
        }

        public <K, V> Map<K, V> getMap(String column, AbstractType<K> keyType, AbstractType<V> valueType) {
            ByteBuffer raw = this.data.get(column);
            return raw == null ? null : (Map)MapType.getInstance(keyType, valueType, true).compose(raw);
        }

        public List<ColumnSpecification> getColumns() {
            return this.columns;
        }

        public String toString() {
            return this.data.toString();
        }
    }

    private static class FromPager
    extends UntypedResultSet {
        private final SelectStatement select;
        private final QueryPager pager;
        private final int pageSize;
        private final List<ColumnSpecification> metadata;

        private FromPager(SelectStatement select, QueryPager pager, int pageSize) {
            this.select = select;
            this.pager = pager;
            this.pageSize = pageSize;
            this.metadata = select.getResultMetadata().names;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Row one() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Row> iterator() {
            return new AbstractIterator<Row>(){
                private Iterator<List<ByteBuffer>> currentPage;

                @Override
                protected Row computeNext() {
                    while (this.currentPage == null || !this.currentPage.hasNext()) {
                        if (FromPager.this.pager.isExhausted()) {
                            return (Row)this.endOfData();
                        }
                        this.currentPage = ((FromPager)FromPager.this).select.process(((FromPager)FromPager.this).pager.fetchPage((int)((FromPager)FromPager.this).pageSize)).rows.iterator();
                    }
                    return new Row(FromPager.this.metadata, this.currentPage.next());
                }
            };
        }

        @Override
        public List<ColumnSpecification> metadata() {
            return this.metadata;
        }
    }

    private static class FromResultList
    extends UntypedResultSet {
        private final List<Map<String, ByteBuffer>> cqlRows;

        private FromResultList(List<Map<String, ByteBuffer>> cqlRows) {
            this.cqlRows = cqlRows;
        }

        @Override
        public int size() {
            return this.cqlRows.size();
        }

        @Override
        public Row one() {
            if (this.cqlRows.size() != 1) {
                throw new IllegalStateException("One row required, " + this.cqlRows.size() + " found");
            }
            return new Row(this.cqlRows.get(0));
        }

        @Override
        public Iterator<Row> iterator() {
            return new AbstractIterator<Row>(){
                Iterator<Map<String, ByteBuffer>> iter;
                {
                    this.iter = FromResultList.this.cqlRows.iterator();
                }

                @Override
                protected Row computeNext() {
                    if (!this.iter.hasNext()) {
                        return (Row)this.endOfData();
                    }
                    return new Row(this.iter.next());
                }
            };
        }

        @Override
        public List<ColumnSpecification> metadata() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FromResultSet
    extends UntypedResultSet {
        private final ResultSet cqlRows;

        private FromResultSet(ResultSet cqlRows) {
            this.cqlRows = cqlRows;
        }

        @Override
        public int size() {
            return this.cqlRows.size();
        }

        @Override
        public Row one() {
            if (this.cqlRows.size() != 1) {
                throw new IllegalStateException("One row required, " + this.cqlRows.size() + " found");
            }
            return new Row(this.cqlRows.metadata.names, this.cqlRows.rows.get(0));
        }

        @Override
        public Iterator<Row> iterator() {
            return new AbstractIterator<Row>(){
                Iterator<List<ByteBuffer>> iter;
                {
                    this.iter = ((FromResultSet)FromResultSet.this).cqlRows.rows.iterator();
                }

                @Override
                protected Row computeNext() {
                    if (!this.iter.hasNext()) {
                        return (Row)this.endOfData();
                    }
                    return new Row(((FromResultSet)FromResultSet.this).cqlRows.metadata.names, this.iter.next());
                }
            };
        }

        @Override
        public List<ColumnSpecification> metadata() {
            return this.cqlRows.metadata.requestNames();
        }
    }
}

