/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.datastax.driver.core.DataType;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.FBUtilities;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaSourceUDFFactory {
    private static final String GENERATED_PACKAGE = "org.apache.cassandra.cql3.udf.gen";
    static final Logger logger = LoggerFactory.getLogger(JavaSourceUDFFactory.class);
    private static final AtomicInteger classSequence = new AtomicInteger();
    private static final ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
    private static final EcjTargetClassLoader targetClassLoader = new EcjTargetClassLoader();
    private static final IErrorHandlingPolicy errorHandlingPolicy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
    private static final IProblemFactory problemFactory = new DefaultProblemFactory(Locale.ENGLISH);
    private static final CompilerOptions compilerOptions;
    private static final String[] javaSourceTemplate;

    static UDFunction buildUDF(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, boolean calledOnNullInput, String body) throws InvalidRequestException {
        DataType[] argDataTypes = UDHelper.driverTypes(argTypes);
        DataType returnDataType = UDHelper.driverType(returnType);
        Class<?>[] javaParamTypes = UDHelper.javaTypes(argDataTypes, calledOnNullInput);
        Class javaReturnType = returnDataType.asJavaClass();
        String clsName = JavaSourceUDFFactory.generateClassName(name);
        StringBuilder javaSourceBuilder = new StringBuilder();
        int lineOffset = 1;
        for (int i = 0; i < javaSourceTemplate.length; ++i) {
            String s = javaSourceTemplate[i];
            if ((i & 1) == 1) {
                switch (s) {
                    case "class_name": {
                        s = clsName;
                        break;
                    }
                    case "body": {
                        lineOffset = JavaSourceUDFFactory.countNewlines(javaSourceBuilder);
                        s = body;
                        break;
                    }
                    case "arguments": {
                        s = JavaSourceUDFFactory.generateArguments(javaParamTypes, argNames);
                        break;
                    }
                    case "argument_list": {
                        s = JavaSourceUDFFactory.generateArgumentList(javaParamTypes, argNames);
                        break;
                    }
                    case "return_type": {
                        s = JavaSourceUDFFactory.javaSourceName(javaReturnType);
                    }
                }
            }
            javaSourceBuilder.append(s);
        }
        String targetClassName = "org.apache.cassandra.cql3.udf.gen." + clsName;
        String javaSource = javaSourceBuilder.toString();
        logger.trace("Compiling Java source UDF '{}' as class '{}' using source:\n{}", name, targetClassName, javaSource);
        try {
            EcjCompilationUnit compilationUnit = new EcjCompilationUnit(javaSource, targetClassName);
            Compiler compiler = new Compiler((INameEnvironment)compilationUnit, errorHandlingPolicy, compilerOptions, (ICompilerRequestor)compilationUnit, problemFactory);
            compiler.compile(new ICompilationUnit[]{compilationUnit});
            if (compilationUnit.problemList != null && !compilationUnit.problemList.isEmpty()) {
                boolean fullSource = false;
                StringBuilder problems = new StringBuilder();
                for (IProblem problem : compilationUnit.problemList) {
                    long ln = problem.getSourceLineNumber() - lineOffset;
                    if (ln < 1L) {
                        if (!problem.isError()) continue;
                        problems.append("GENERATED SOURCE ERROR: line ").append(problem.getSourceLineNumber()).append(" (in generated source): ").append(problem.getMessage()).append('\n');
                        fullSource = true;
                        continue;
                    }
                    problems.append("Line ").append(Long.toString(ln)).append(": ").append(problem.getMessage()).append('\n');
                }
                if (fullSource) {
                    throw new InvalidRequestException("Java source compilation failed:\n" + problems + "\n generated source:\n" + javaSource);
                }
                throw new InvalidRequestException("Java source compilation failed:\n" + problems);
            }
            Class<?> cls = targetClassLoader.loadClass(targetClassName);
            if (cls.getDeclaredMethods().length != 2 || cls.getDeclaredConstructors().length != 1) {
                throw new InvalidRequestException("Check your source to not define additional Java methods or constructors");
            }
            MethodType methodType = MethodType.methodType(Void.TYPE).appendParameterTypes(FunctionName.class, List.class, List.class, DataType[].class, AbstractType.class, DataType.class, Boolean.TYPE, String.class);
            MethodHandle ctor = MethodHandles.lookup().findConstructor(cls, methodType);
            return (UDFunction)ctor.invokeWithArguments(name, argNames, argTypes, argDataTypes, returnType, returnDataType, calledOnNullInput, body);
        }
        catch (InvocationTargetException e) {
            throw new InvalidRequestException(String.format("Could not compile function '%s' from Java source: %s", name, e.getCause()));
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvalidRequestException(String.format("Could not compile function '%s' from Java source: %s", name, e));
        }
    }

    private static int countNewlines(StringBuilder javaSource) {
        int ln = 0;
        for (int i = 0; i < javaSource.length(); ++i) {
            if (javaSource.charAt(i) != '\n') continue;
            ++ln;
        }
        return ln;
    }

    private static String generateClassName(FunctionName name) {
        String qualifiedName = name.toString();
        StringBuilder sb = new StringBuilder(qualifiedName.length() + 10);
        sb.append('C');
        for (int i = 0; i < qualifiedName.length(); ++i) {
            char c = qualifiedName.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            sb.append(c);
        }
        sb.append('_').append(classSequence.incrementAndGet());
        return sb.toString();
    }

    private static String javaSourceName(Class<?> type) {
        String n = type.getName();
        return n.startsWith("java.lang.") ? type.getSimpleName() : n;
    }

    private static String generateArgumentList(Class<?>[] paramTypes, List<ColumnIdentifier> argNames) {
        StringBuilder code = new StringBuilder(32 * paramTypes.length);
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                code.append(", ");
            }
            code.append(JavaSourceUDFFactory.javaSourceName(paramTypes[i])).append(' ').append(argNames.get(i));
        }
        return code.toString();
    }

    private static String generateArguments(Class<?>[] paramTypes, List<ColumnIdentifier> argNames) {
        StringBuilder code = new StringBuilder(64 * paramTypes.length);
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                code.append(",\n");
            }
            if (logger.isTraceEnabled()) {
                code.append("                /* parameter '").append(argNames.get(i)).append("' */\n");
            }
            code.append("                (").append(JavaSourceUDFFactory.javaSourceName(paramTypes[i])).append(") ").append(JavaSourceUDFFactory.composeMethod(paramTypes[i])).append("(protocolVersion, ").append(i).append(", params.get(").append(i).append("))");
        }
        return code.toString();
    }

    private static String composeMethod(Class<?> type) {
        return type.isPrimitive() ? "compose_" + type.getName() : "compose";
    }

    static {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "disabled");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        settings.put("org.eclipse.jdt.core.compiler.source", "1.7");
        settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
        compilerOptions = new CompilerOptions(settings);
        JavaSourceUDFFactory.compilerOptions.parseLiteralExpressionsAsConstants = true;
        try (InputStream input = JavaSourceUDFFactory.class.getResource("JavaSourceUDF.txt").openConnection().getInputStream();){
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            FBUtilities.copy(input, output, Long.MAX_VALUE);
            String template = output.toString();
            StringTokenizer st = new StringTokenizer(template, "#");
            javaSourceTemplate = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreElements()) {
                JavaSourceUDFFactory.javaSourceTemplate[i] = st.nextToken();
                ++i;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static final class EcjTargetClassLoader
    extends ClassLoader {
        private final Map<String, byte[]> classes = new ConcurrentHashMap<String, byte[]>();

        EcjTargetClassLoader() {
            super(baseClassLoader);
        }

        public void addClass(String className, byte[] classData) {
            this.classes.put(className, classData);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] classData = this.classes.remove(name);
            return classData != null ? this.defineClass(name, classData, 0, classData.length) : super.findClass(name);
        }
    }

    static final class EcjCompilationUnit
    implements ICompilationUnit,
    ICompilerRequestor,
    INameEnvironment {
        List<IProblem> problemList;
        private final String className;
        private final char[] sourceCode;

        EcjCompilationUnit(String sourceCode, String className) {
            this.className = className;
            this.sourceCode = sourceCode.toCharArray();
        }

        public char[] getFileName() {
            return this.sourceCode;
        }

        public char[] getContents() {
            return this.sourceCode;
        }

        public char[] getMainTypeName() {
            int dot = this.className.lastIndexOf(46);
            return (dot > 0 ? this.className.substring(dot + 1) : this.className).toCharArray();
        }

        public char[][] getPackageName() {
            StringTokenizer izer = new StringTokenizer(this.className, ".");
            char[][] result = new char[izer.countTokens() - 1][];
            for (int i = 0; i < result.length; ++i) {
                result[i] = izer.nextToken().toCharArray();
            }
            return result;
        }

        public boolean ignoreOptionalProblems() {
            return false;
        }

        public void acceptResult(CompilationResult result) {
            if (result.hasErrors()) {
                CategorizedProblem[] problems = result.getProblems();
                if (this.problemList == null) {
                    this.problemList = new ArrayList<IProblem>(problems.length);
                }
                Collections.addAll(this.problemList, problems);
            } else {
                ClassFile[] classFiles;
                for (ClassFile classFile : classFiles = result.getClassFiles()) {
                    targetClassLoader.addClass(this.className, classFile.getBytes());
                }
            }
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < compoundTypeName.length; ++i) {
                if (i > 0) {
                    result.append('.');
                }
                result.append(compoundTypeName[i]);
            }
            return this.findType(result.toString());
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            int i;
            StringBuilder result = new StringBuilder();
            for (i = 0; i < packageName.length; ++i) {
                if (i > 0) {
                    result.append('.');
                }
                result.append(packageName[i]);
            }
            if (i > 0) {
                result.append('.');
            }
            result.append(typeName);
            return this.findType(result.toString());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private NameEnvironmentAnswer findType(String className) {
            if (className.equals(this.className)) {
                return new NameEnvironmentAnswer((ICompilationUnit)this, null);
            }
            String resourceName = className.replace('.', '/') + ".class";
            try (InputStream is = baseClassLoader.getResourceAsStream(resourceName);){
                if (is == null) return null;
                byte[] classBytes = ByteStreams.toByteArray(is);
                char[] fileName = className.toCharArray();
                ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                return nameEnvironmentAnswer;
            }
            catch (IOException | ClassFormatException exc) {
                throw new RuntimeException(exc);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isPackage(String result) {
            if (result.equals(this.className)) {
                return false;
            }
            String resourceName = result.replace('.', '/') + ".class";
            try (InputStream is = baseClassLoader.getResourceAsStream(resourceName);){
                boolean bl = is == null;
                return bl;
            }
            catch (IOException e) {
                return false;
            }
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            int i;
            StringBuilder result = new StringBuilder();
            if (parentPackageName != null) {
                for (i = 0; i < parentPackageName.length; ++i) {
                    if (i > 0) {
                        result.append('.');
                    }
                    result.append(parentPackageName[i]);
                }
            }
            if (Character.isUpperCase(packageName[0]) && !this.isPackage(result.toString())) {
                return false;
            }
            if (i > 0) {
                result.append('.');
            }
            result.append(packageName);
            return this.isPackage(result.toString());
        }

        public void cleanup() {
        }
    }
}

