/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.FunctionExecutionException;
import org.apache.cassandra.exceptions.InvalidRequestException;

public class ScriptBasedUDF
extends UDFunction {
    static final Map<String, Compilable> scriptEngines = new HashMap<String, Compilable>();
    private final CompiledScript script;

    ScriptBasedUDF(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, boolean calledOnNullInput, String language, String body) throws InvalidRequestException {
        super(name, argNames, argTypes, returnType, calledOnNullInput, language, body);
        Compilable scriptEngine = scriptEngines.get(language);
        if (scriptEngine == null) {
            throw new InvalidRequestException(String.format("Invalid language '%s' for function '%s'", language, name));
        }
        try {
            this.script = scriptEngine.compile(body);
        }
        catch (RuntimeException | ScriptException e) {
            logger.info("Failed to compile function '{}' for language {}: ", name, language, e);
            throw new InvalidRequestException(String.format("Failed to compile function '%s' for language %s: %s", name, language, e));
        }
    }

    @Override
    public ByteBuffer executeUserDefined(int protocolVersion, List<ByteBuffer> parameters) throws InvalidRequestException {
        Object[] params = new Object[this.argTypes.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.compose(protocolVersion, i, parameters.get(i));
        }
        try {
            Class<?> resultType;
            SimpleBindings bindings = new SimpleBindings();
            for (int i = 0; i < params.length; ++i) {
                bindings.put(((ColumnIdentifier)this.argNames.get(i)).toString(), params[i]);
            }
            Object result = this.script.eval(bindings);
            if (result == null) {
                return null;
            }
            Class javaReturnType = this.returnDataType.asJavaClass();
            if (!javaReturnType.isAssignableFrom(resultType = result.getClass()) && result instanceof Number) {
                Number rNumber = (Number)result;
                if (javaReturnType == Integer.class) {
                    result = rNumber.intValue();
                } else if (javaReturnType == Short.class) {
                    result = rNumber.shortValue();
                } else if (javaReturnType == Byte.class) {
                    result = rNumber.byteValue();
                } else if (javaReturnType == Long.class) {
                    result = rNumber.longValue();
                } else if (javaReturnType == Float.class) {
                    result = Float.valueOf(rNumber.floatValue());
                } else if (javaReturnType == Double.class) {
                    result = rNumber.doubleValue();
                } else if (javaReturnType == BigInteger.class) {
                    result = rNumber instanceof BigDecimal ? ((BigDecimal)rNumber).toBigInteger() : (rNumber instanceof Double || rNumber instanceof Float ? new BigDecimal(rNumber.toString()).toBigInteger() : BigInteger.valueOf(rNumber.longValue()));
                } else if (javaReturnType == BigDecimal.class) {
                    result = new BigDecimal(rNumber.toString());
                }
            }
            return this.decompose(protocolVersion, result);
        }
        catch (RuntimeException | ScriptException e) {
            logger.trace("Execution of UDF '{}' failed", (Object)this.name, (Object)e);
            throw FunctionExecutionException.create(this, e);
        }
    }

    static {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        for (ScriptEngineFactory scriptEngineFactory : scriptEngineManager.getEngineFactories()) {
            ScriptEngine scriptEngine = scriptEngineFactory.getScriptEngine();
            boolean compilable = scriptEngine instanceof Compilable;
            if (!compilable) continue;
            logger.info("Found scripting engine {} {} - {} {} - language names: {}", scriptEngineFactory.getEngineName(), scriptEngineFactory.getEngineVersion(), scriptEngineFactory.getLanguageName(), scriptEngineFactory.getLanguageVersion(), scriptEngineFactory.getNames());
            for (String name : scriptEngineFactory.getNames()) {
                scriptEngines.put(name, (Compilable)((Object)scriptEngine));
            }
        }
    }
}

