/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.selection.SelectionColumns;

public class SelectionColumnMapping
implements SelectionColumns {
    private final ArrayList<ColumnSpecification> columnSpecifications = new ArrayList();
    private final HashMultimap<ColumnSpecification, ColumnDefinition> columnMappings = HashMultimap.create();

    private SelectionColumnMapping() {
    }

    protected static SelectionColumnMapping newMapping() {
        return new SelectionColumnMapping();
    }

    protected static SelectionColumnMapping simpleMapping(Iterable<ColumnDefinition> columnDefinitions) {
        SelectionColumnMapping mapping = new SelectionColumnMapping();
        for (ColumnDefinition def : columnDefinitions) {
            mapping.addMapping((ColumnSpecification)def, def);
        }
        return mapping;
    }

    protected SelectionColumnMapping addMapping(ColumnSpecification colSpec, ColumnDefinition column) {
        this.columnSpecifications.add(colSpec);
        if (column != null) {
            this.columnMappings.put((Object)colSpec, (Object)column);
        }
        return this;
    }

    protected SelectionColumnMapping addMapping(ColumnSpecification colSpec, Iterable<ColumnDefinition> columns) {
        this.columnSpecifications.add(colSpec);
        this.columnMappings.putAll((Object)colSpec, columns);
        return this;
    }

    @Override
    public List<ColumnSpecification> getColumnSpecifications() {
        return Lists.newArrayList(this.columnSpecifications);
    }

    @Override
    public Multimap<ColumnSpecification, ColumnDefinition> getMappings() {
        return Multimaps.unmodifiableMultimap(this.columnMappings);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectionColumnMapping)) {
            return false;
        }
        SelectionColumns other = (SelectionColumns)obj;
        return Objects.equal(this.columnMappings, other.getMappings()) && Objects.equal(this.columnSpecifications, other.getColumnSpecifications());
    }

    public int hashCode() {
        return Objects.hashCode(this.columnMappings);
    }

    public String toString() {
        final Function<ColumnDefinition, String> getDefName = new Function<ColumnDefinition, String>(){

            @Override
            public String apply(ColumnDefinition def) {
                return def.name.toString();
            }
        };
        Function<Map.Entry<ColumnSpecification, Collection<ColumnDefinition>>, String> mappingEntryToString = new Function<Map.Entry<ColumnSpecification, Collection<ColumnDefinition>>, String>(){

            @Override
            public String apply(Map.Entry<ColumnSpecification, Collection<ColumnDefinition>> entry) {
                StringBuilder builder = new StringBuilder();
                builder.append(entry.getKey().name.toString());
                builder.append(":[");
                builder.append(Joiner.on(',').join(Iterables.transform((Iterable)entry.getValue(), getDefName)));
                builder.append("]");
                return builder.toString();
            }
        };
        Function<ColumnSpecification, String> colSpecToString = new Function<ColumnSpecification, String>(){

            @Override
            public String apply(ColumnSpecification columnSpecification) {
                return columnSpecification.name.toString();
            }
        };
        StringBuilder builder = new StringBuilder();
        builder.append("{ Columns:[");
        builder.append(Joiner.on(",").join(Iterables.transform(this.columnSpecifications, colSpecToString)));
        builder.append("], Mappings:[");
        builder.append(Joiner.on(", ").join(Iterables.transform(this.columnMappings.asMap().entrySet(), mappingEntryToString)));
        builder.append("] }");
        return builder.toString();
    }
}

