/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.CASRequest;
import org.apache.cassandra.utils.Pair;

public class CQL3CasRequest
implements CASRequest {
    final CFMetaData cfm;
    final ByteBuffer key;
    final long now;
    final boolean isBatch;
    private final SortedMap<Composite, RowCondition> conditions;
    private final List<RowUpdate> updates = new ArrayList<RowUpdate>();

    public CQL3CasRequest(CFMetaData cfm, ByteBuffer key, boolean isBatch) {
        this.cfm = cfm;
        this.now = System.currentTimeMillis();
        this.key = key;
        this.conditions = new TreeMap<Composite, RowCondition>(cfm.comparator);
        this.isBatch = isBatch;
    }

    public void addRowUpdate(Composite prefix, ModificationStatement stmt, QueryOptions options, long timestamp) {
        this.updates.add(new RowUpdate(prefix, stmt, options, timestamp));
    }

    public void addNotExist(Composite prefix) throws InvalidRequestException {
        RowCondition previous = this.conditions.put(prefix, new NotExistCondition(prefix, this.now));
        if (previous != null && !(previous instanceof NotExistCondition)) {
            if (previous instanceof ExistCondition) {
                throw new InvalidRequestException("Cannot mix IF EXISTS and IF NOT EXISTS conditions for the same row");
            }
            throw new InvalidRequestException("Cannot mix IF conditions and IF NOT EXISTS for the same row");
        }
    }

    public void addExist(Composite prefix) throws InvalidRequestException {
        RowCondition previous = this.conditions.put(prefix, new ExistCondition(prefix, this.now));
        if (previous instanceof NotExistCondition) {
            throw new InvalidRequestException("Cannot mix IF EXISTS and IF NOT EXISTS conditions for the same row");
        }
    }

    public void addConditions(Composite prefix, Collection<ColumnCondition> conds, QueryOptions options) throws InvalidRequestException {
        RowCondition condition = (RowCondition)this.conditions.get(prefix);
        if (condition == null) {
            condition = new ColumnsConditions(prefix, this.now);
            this.conditions.put(prefix, condition);
        } else if (!(condition instanceof ColumnsConditions)) {
            throw new InvalidRequestException("Cannot mix IF conditions and IF NOT EXISTS for the same row");
        }
        ((ColumnsConditions)condition).addConditions(conds, options);
    }

    @Override
    public IDiskAtomFilter readFilter() {
        assert (!this.conditions.isEmpty());
        ColumnSlice[] slices = new ColumnSlice[this.conditions.size()];
        int i = 0;
        for (Composite prefix : this.conditions.keySet()) {
            slices[i++] = prefix.slice();
        }
        int toGroup = this.cfm.comparator.isDense() ? -1 : this.cfm.clusteringColumns().size();
        slices = ColumnSlice.deoverlapSlices(slices, this.cfm.comparator);
        assert (ColumnSlice.validateSlices(slices, this.cfm.comparator, false));
        return new SliceQueryFilter(slices, false, slices.length, toGroup);
    }

    @Override
    public boolean appliesTo(ColumnFamily current) throws InvalidRequestException {
        for (RowCondition condition : this.conditions.values()) {
            if (condition.appliesTo(current)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ColumnFamily makeUpdates(ColumnFamily current) throws InvalidRequestException {
        ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(this.cfm);
        for (RowUpdate upd : this.updates) {
            upd.applyUpdates(current, cf);
        }
        if (this.isBatch) {
            BatchStatement.verifyBatchSize(Collections.singleton(cf));
        }
        return cf;
    }

    private static class ColumnsConditions
    extends RowCondition {
        private final Multimap<Pair<ColumnIdentifier, ByteBuffer>, ColumnCondition.Bound> conditions = HashMultimap.create();

        private ColumnsConditions(Composite rowPrefix, long now) {
            super(rowPrefix, now);
        }

        public void addConditions(Collection<ColumnCondition> conds, QueryOptions options) throws InvalidRequestException {
            for (ColumnCondition condition : conds) {
                ColumnCondition.Bound current = condition.bind(options);
                this.conditions.put(Pair.create(condition.column.name, current.getCollectionElementValue()), current);
            }
        }

        @Override
        public boolean appliesTo(ColumnFamily current) throws InvalidRequestException {
            if (current == null) {
                return this.conditions.isEmpty();
            }
            for (ColumnCondition.Bound condition : this.conditions.values()) {
                if (condition.appliesTo(this.rowPrefix, current, this.now)) continue;
                return false;
            }
            return true;
        }
    }

    private static class ExistCondition
    extends RowCondition {
        private ExistCondition(Composite rowPrefix, long now) {
            super(rowPrefix, now);
        }

        @Override
        public boolean appliesTo(ColumnFamily current) {
            if (current == null) {
                return false;
            }
            Iterator<Cell> iter2 = current.iterator(new ColumnSlice[]{this.rowPrefix.slice()});
            while (iter2.hasNext()) {
                if (!iter2.next().isLive(this.now)) continue;
                return true;
            }
            return false;
        }
    }

    private static class NotExistCondition
    extends RowCondition {
        private NotExistCondition(Composite rowPrefix, long now) {
            super(rowPrefix, now);
        }

        @Override
        public boolean appliesTo(ColumnFamily current) {
            if (current == null) {
                return true;
            }
            Iterator<Cell> iter2 = current.iterator(new ColumnSlice[]{this.rowPrefix.slice()});
            while (iter2.hasNext()) {
                if (!iter2.next().isLive(this.now)) continue;
                return false;
            }
            return true;
        }
    }

    private static abstract class RowCondition {
        public final Composite rowPrefix;
        protected final long now;

        protected RowCondition(Composite rowPrefix, long now) {
            this.rowPrefix = rowPrefix;
            this.now = now;
        }

        public abstract boolean appliesTo(ColumnFamily var1) throws InvalidRequestException;
    }

    private class RowUpdate {
        private final Composite rowPrefix;
        private final ModificationStatement stmt;
        private final QueryOptions options;
        private final long timestamp;

        private RowUpdate(Composite rowPrefix, ModificationStatement stmt, QueryOptions options, long timestamp) {
            this.rowPrefix = rowPrefix;
            this.stmt = stmt;
            this.options = options;
            this.timestamp = timestamp;
        }

        public void applyUpdates(ColumnFamily current, ColumnFamily updates) throws InvalidRequestException {
            CQL3Row.RowIterator iter2;
            Map map = null;
            if (this.stmt.requiresRead() && (iter2 = CQL3CasRequest.this.cfm.comparator.CQL3RowBuilder(CQL3CasRequest.this.cfm, CQL3CasRequest.this.now).group(current.iterator(new ColumnSlice[]{this.rowPrefix.slice()}))).hasNext()) {
                map = Collections.singletonMap(CQL3CasRequest.this.key, iter2.next());
                assert (!iter2.hasNext()) : "We shoudn't be updating more than one CQL row per-ModificationStatement";
            }
            UpdateParameters params = new UpdateParameters(CQL3CasRequest.this.cfm, this.options, this.timestamp, this.stmt.getTimeToLive(this.options), map);
            this.stmt.addUpdateForKey(updates, CQL3CasRequest.this.key, this.rowPrefix, params);
        }
    }
}

