/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.memory.HeapAllocator;

public class CollationController {
    private final ColumnFamilyStore cfs;
    private final QueryFilter filter;
    private final int gcBefore;
    private int sstablesIterated = 0;

    public CollationController(ColumnFamilyStore cfs, QueryFilter filter, int gcBefore) {
        this.cfs = cfs;
        this.filter = filter;
        this.gcBefore = gcBefore;
    }

    public ColumnFamily getTopLevelColumns(boolean copyOnHeap) {
        return this.filter.filter instanceof NamesQueryFilter && this.cfs.metadata.getDefaultValidator() != CounterColumnType.instance ? this.collectTimeOrderedData(copyOnHeap) : this.collectAllData(copyOnHeap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily collectTimeOrderedData(boolean copyOnHeap) {
        ArrayBackedSortedColumns container = ArrayBackedSortedColumns.factory.create(this.cfs.metadata, this.filter.filter.isReversed());
        ArrayList<OnDiskAtomIterator> iterators = new ArrayList<OnDiskAtomIterator>();
        boolean isEmpty = true;
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = this.cfs.select(this.cfs.viewFilter(this.filter.key));
        DeletionInfo returnDeletionInfo = ((ColumnFamily)container).deletionInfo();
        try {
            Object sstable;
            Iterator<Object> iter2;
            Tracing.trace("Merging memtable contents");
            for (Memtable memtable : view.memtables) {
                ColumnFamily cf = memtable.getColumnFamily(this.filter.key);
                if (cf == null) continue;
                this.filter.delete(((ColumnFamily)container).deletionInfo(), cf);
                isEmpty = false;
                iter2 = this.filter.getIterator(cf);
                while (iter2.hasNext()) {
                    Cell cell = iter2.next();
                    if (copyOnHeap) {
                        cell = cell.localCopy(this.cfs.metadata, HeapAllocator.instance);
                    }
                    ((ColumnFamily)container).addColumn(cell);
                }
            }
            NamesQueryFilter namesFilter = (NamesQueryFilter)this.filter.filter;
            TreeSet<CellName> filterColumns = new TreeSet<CellName>(namesFilter.columns);
            QueryFilter reducedFilter = new QueryFilter(this.filter.key, this.filter.cfName, namesFilter.withUpdatedColumns(filterColumns), this.filter.timestamp);
            Collections.sort(view.sstables, SSTableReader.maxTimestampComparator);
            iter2 = view.sstables.iterator();
            while (iter2.hasNext() && ((SSTableReader)(sstable = (SSTableReader)iter2.next())).getMaxTimestamp() >= returnDeletionInfo.getTopLevelDeletion().markedForDeleteAt) {
                long currentMaxTs = ((SSTableReader)sstable).getMaxTimestamp();
                this.reduceNameFilter(reducedFilter, container, currentMaxTs);
                if (((NamesQueryFilter)reducedFilter.filter).columns.isEmpty()) break;
                Tracing.trace("Merging data from sstable {}", (Object)((SSTableReader)sstable).descriptor.generation);
                ((SSTableReader)sstable).incrementReadCount();
                OnDiskAtomIterator iter3 = reducedFilter.getSSTableColumnIterator((SSTableReader)sstable);
                iterators.add(iter3);
                isEmpty = false;
                if (iter3.getColumnFamily() == null) continue;
                container.delete(iter3.getColumnFamily());
                ++this.sstablesIterated;
                while (iter3.hasNext()) {
                    container.addAtom((OnDiskAtom)iter3.next());
                }
            }
            if (isEmpty) {
                iter2 = null;
                return iter2;
            }
            ColumnFamily returnCF = container.cloneMeShallow();
            Tracing.trace("Collating all results");
            this.filter.collateOnDiskAtom(returnCF, container.iterator(), this.gcBefore);
            if (this.sstablesIterated > this.cfs.getMinimumCompactionThreshold() && !this.cfs.isAutoCompactionDisabled() && this.cfs.getCompactionStrategy().shouldDefragment()) {
                Tracing.trace("Defragmenting requested data");
                final Mutation mutation = new Mutation(this.cfs.keyspace.getName(), this.filter.key.getKey(), returnCF.cloneMe());
                StageManager.getStage(Stage.MUTATION).execute(new Runnable(){

                    @Override
                    public void run() {
                        Keyspace.open(mutation.getKeyspaceName()).apply(mutation, false, false);
                    }
                });
            }
            ColumnFamily columnFamily = returnCF;
            return columnFamily;
        }
        finally {
            for (OnDiskAtomIterator iter4 : iterators) {
                FileUtils.closeQuietly(iter4);
            }
        }
    }

    private void reduceNameFilter(QueryFilter filter, ColumnFamily container, long sstableTimestamp) {
        if (container == null) {
            return;
        }
        SearchIterator<CellName, Cell> searchIter = container.searchIterator();
        Iterator iterator = ((NamesQueryFilter)filter.filter).columns.iterator();
        while (iterator.hasNext() && searchIter.hasNext()) {
            CellName filterColumn = (CellName)iterator.next();
            Cell cell = searchIter.next(filterColumn);
            if (cell == null || cell.timestamp() <= sstableTimestamp) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily collectAllData(boolean copyOnHeap) {
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = this.cfs.select(this.cfs.viewFilter(this.filter.key));
        ArrayList<Iterator<Cell>> iterators = new ArrayList<Iterator<Cell>>(Iterables.size(view.memtables) + view.sstables.size());
        ArrayBackedSortedColumns returnCF = ArrayBackedSortedColumns.factory.create(this.cfs.metadata, this.filter.filter.isReversed());
        DeletionInfo returnDeletionInfo = ((ColumnFamily)returnCF).deletionInfo();
        try {
            Object object;
            Tracing.trace("Merging memtable tombstones");
            for (Memtable memtable : view.memtables) {
                final ColumnFamily cf = memtable.getColumnFamily(this.filter.key);
                if (cf == null) continue;
                this.filter.delete(returnDeletionInfo, cf);
                Iterator<Cell> iter2 = this.filter.getIterator(cf);
                if (copyOnHeap) {
                    iter2 = Iterators.transform(iter2, new Function<Cell, Cell>(){

                        @Override
                        public Cell apply(Cell cell) {
                            return cell.localCopy(cf.metadata, HeapAllocator.instance);
                        }
                    });
                }
                iterators.add(iter2);
            }
            Collections.sort(view.sstables, SSTableReader.maxTimestampComparator);
            ArrayList<SSTableReader> skippedSSTables = null;
            long minTimestamp = Long.MAX_VALUE;
            int nonIntersectingSSTables = 0;
            for (SSTableReader sstable : view.sstables) {
                minTimestamp = Math.min(minTimestamp, sstable.getMinTimestamp());
                if (sstable.getMaxTimestamp() < returnDeletionInfo.getTopLevelDeletion().markedForDeleteAt) break;
                if (!this.filter.shouldInclude(sstable)) {
                    ++nonIntersectingSSTables;
                    if (sstable.getSSTableMetadata().maxLocalDeletionTime == Integer.MAX_VALUE) continue;
                    if (skippedSSTables == null) {
                        skippedSSTables = new ArrayList<SSTableReader>();
                    }
                    skippedSSTables.add(sstable);
                    continue;
                }
                sstable.incrementReadCount();
                OnDiskAtomIterator iter3 = this.filter.getSSTableColumnIterator(sstable);
                iterators.add(iter3);
                if (iter3.getColumnFamily() == null) continue;
                ColumnFamily columnFamily = iter3.getColumnFamily();
                returnCF.delete(columnFamily);
                ++this.sstablesIterated;
            }
            int includedDueToTombstones = 0;
            if (skippedSSTables != null) {
                for (SSTableReader sstable : skippedSSTables) {
                    if (sstable.getMaxTimestamp() <= minTimestamp) continue;
                    sstable.incrementReadCount();
                    OnDiskAtomIterator onDiskAtomIterator = this.filter.getSSTableColumnIterator(sstable);
                    ColumnFamily cf = onDiskAtomIterator.getColumnFamily();
                    if (cf != null && cf.deletionInfo().getTopLevelDeletion().markedForDeleteAt > minTimestamp) {
                        ++includedDueToTombstones;
                        iterators.add(onDiskAtomIterator);
                        ((ColumnFamily)returnCF).delete(cf.deletionInfo().getTopLevelDeletion());
                        ++this.sstablesIterated;
                        continue;
                    }
                    FileUtils.closeQuietly(onDiskAtomIterator);
                }
            }
            if (Tracing.isTracing()) {
                Tracing.trace("Skipped {}/{} non-slice-intersecting sstables, included {} due to tombstones", nonIntersectingSSTables, view.sstables.size(), includedDueToTombstones);
            }
            if (iterators.isEmpty()) {
                object = null;
                return object;
            }
            Tracing.trace("Merging data from memtables and {} sstables", (Object)this.sstablesIterated);
            this.filter.collateOnDiskAtom((ColumnFamily)returnCF, iterators, this.gcBefore);
            object = returnCF;
            return object;
        }
        finally {
            for (Object e : iterators) {
                if (!(e instanceof Closeable)) continue;
                FileUtils.closeQuietly((Closeable)e);
            }
        }
    }

    public int getSstablesIterated() {
        return this.sstablesIterated;
    }
}

