/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.ImmutableMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.AbstractCell;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.BufferCounterUpdateCell;
import org.apache.cassandra.db.BufferDeletedCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamilySerializer;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnCounter;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.io.sstable.ColumnNameHelper;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.BatchRemoveIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.StreamingHistogram;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ColumnFamily
implements Iterable<Cell>,
IRowCacheEntry {
    public static final ColumnFamilySerializer serializer = new ColumnFamilySerializer();
    protected final CFMetaData metadata;

    protected ColumnFamily(CFMetaData metadata) {
        assert (metadata != null);
        this.metadata = metadata;
    }

    public <T extends ColumnFamily> T cloneMeShallow(Factory<T> factory, boolean reversedInsertOrder) {
        T cf = factory.create(this.metadata, reversedInsertOrder);
        ((ColumnFamily)cf).delete(this);
        return cf;
    }

    public ColumnFamily cloneMeShallow() {
        return this.cloneMeShallow(false);
    }

    public ColumnFamily cloneMeShallow(boolean reversed) {
        return this.cloneMeShallow(this.getFactory(), reversed);
    }

    public ColumnFamilyType getType() {
        return this.metadata.cfType;
    }

    public int liveCQL3RowCount(long now) {
        ColumnCounter counter = this.getComparator().isDense() ? new ColumnCounter(now) : new ColumnCounter.GroupByPrefix(now, this.getComparator(), this.metadata.clusteringColumns().size());
        return counter.countAll(this).live();
    }

    public abstract ColumnFamily cloneMe();

    public UUID id() {
        return this.metadata.cfId;
    }

    public CFMetaData metadata() {
        return this.metadata;
    }

    public void addColumn(CellName name, ByteBuffer value, long timestamp) {
        this.addColumn(name, value, timestamp, 0);
    }

    public void addColumn(CellName name, ByteBuffer value, long timestamp, int timeToLive) {
        assert (!this.metadata().isCounter());
        Cell cell = AbstractCell.create(name, value, timestamp, timeToLive, this.metadata());
        this.addColumn(cell);
    }

    public void addCounter(CellName name, long value) {
        this.addColumn(new BufferCounterUpdateCell(name, value, FBUtilities.timestampMicros()));
    }

    public void addTombstone(CellName name, ByteBuffer localDeletionTime, long timestamp) {
        this.addColumn(new BufferDeletedCell(name, localDeletionTime, timestamp));
    }

    public void addTombstone(CellName name, int localDeletionTime, long timestamp) {
        this.addColumn(new BufferDeletedCell(name, localDeletionTime, timestamp));
    }

    public void addAtom(OnDiskAtom atom) {
        if (atom instanceof Cell) {
            this.addColumn((Cell)atom);
        } else {
            assert (atom instanceof RangeTombstone);
            this.delete((RangeTombstone)atom);
        }
    }

    public abstract void clear();

    public DeletionInfo.InOrderTester inOrderDeletionTester() {
        return this.deletionInfo().inOrderTester();
    }

    public abstract Factory getFactory();

    public abstract DeletionInfo deletionInfo();

    public abstract void setDeletionInfo(DeletionInfo var1);

    public abstract void delete(DeletionInfo var1);

    public abstract void delete(DeletionTime var1);

    protected abstract void delete(RangeTombstone var1);

    public abstract SearchIterator<CellName, Cell> searchIterator();

    public abstract void purgeTombstones(int var1);

    public abstract void addColumn(Cell var1);

    public abstract void maybeAppendColumn(Cell var1, DeletionInfo.InOrderTester var2, int var3);

    public abstract void appendColumn(Cell var1);

    public abstract void addAll(ColumnFamily var1);

    public abstract Cell getColumn(CellName var1);

    public abstract Iterable<CellName> getColumnNames();

    public abstract Collection<Cell> getSortedColumns();

    public abstract Collection<Cell> getReverseSortedColumns();

    public abstract int getColumnCount();

    public abstract boolean hasColumns();

    public boolean isEmpty() {
        return this.deletionInfo().isLive() && !this.hasColumns();
    }

    public abstract Iterator<Cell> iterator(ColumnSlice[] var1);

    public abstract Iterator<Cell> reverseIterator(ColumnSlice[] var1);

    public abstract boolean isInsertReversed();

    public void delete(ColumnFamily columns) {
        this.delete(columns.deletionInfo());
    }

    public ColumnFamily diff(ColumnFamily cfComposite) {
        assert (cfComposite.id().equals(this.id()));
        ArrayBackedSortedColumns cfDiff = ArrayBackedSortedColumns.factory.create(this.metadata);
        ((ColumnFamily)cfDiff).delete(cfComposite.deletionInfo());
        for (Cell cellExternal : cfComposite) {
            CellName cName = cellExternal.name();
            Cell cellInternal = this.getColumn(cName);
            if (cellInternal == null) {
                ((ColumnFamily)cfDiff).addColumn(cellExternal);
                continue;
            }
            Cell cellDiff = cellInternal.diff(cellExternal);
            if (cellDiff == null) continue;
            ((ColumnFamily)cfDiff).addColumn(cellDiff);
        }
        ((ColumnFamily)cfDiff).setDeletionInfo(this.deletionInfo().diff(cfComposite.deletionInfo()));
        if (!cfDiff.isEmpty()) {
            return cfDiff;
        }
        return null;
    }

    public long dataSize() {
        long size = 0L;
        for (Cell cell : this) {
            size += (long)cell.cellDataSize();
        }
        return size;
    }

    public long maxTimestamp() {
        long maxTimestamp = this.deletionInfo().maxTimestamp();
        for (Cell cell : this) {
            maxTimestamp = Math.max(maxTimestamp, cell.timestamp());
        }
        return maxTimestamp;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(373, 75437).append(this.metadata).append(this.deletionInfo());
        for (Cell cell : this) {
            builder.append(cell);
        }
        return builder.toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ColumnFamily)) {
            return false;
        }
        ColumnFamily comparison = (ColumnFamily)o;
        return this.metadata.equals(comparison.metadata) && this.deletionInfo().equals(comparison.deletionInfo()) && ByteBufferUtil.compareUnsigned(ColumnFamily.digest(this), ColumnFamily.digest(comparison)) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnFamily(");
        sb.append(this.metadata.cfName);
        if (this.isMarkedForDelete()) {
            sb.append(" -").append(this.deletionInfo()).append("-");
        }
        sb.append(" [").append(CellNames.getColumnsString(this.getComparator(), this)).append("])");
        return sb.toString();
    }

    public static ByteBuffer digest(ColumnFamily cf) {
        MessageDigest digest = FBUtilities.threadLocalMD5Digest();
        if (cf != null) {
            cf.updateDigest(digest);
        }
        return ByteBuffer.wrap(digest.digest());
    }

    public void updateDigest(MessageDigest digest) {
        for (Cell cell : this) {
            cell.updateDigest(digest);
        }
        this.deletionInfo().updateDigest(digest);
    }

    public static ColumnFamily diff(ColumnFamily cf1, ColumnFamily cf2) {
        if (cf1 == null) {
            return cf2;
        }
        return cf1.diff(cf2);
    }

    public ColumnStats getColumnStats() {
        ColumnStats.MinLongTracker minTimestampTracker = new ColumnStats.MinLongTracker(Long.MIN_VALUE);
        ColumnStats.MaxLongTracker maxTimestampTracker = new ColumnStats.MaxLongTracker(Long.MAX_VALUE);
        StreamingHistogram tombstones = new StreamingHistogram(100);
        ColumnStats.MaxIntTracker maxDeletionTimeTracker = new ColumnStats.MaxIntTracker(Integer.MAX_VALUE);
        List<ByteBuffer> minColumnNamesSeen = Collections.emptyList();
        List<ByteBuffer> maxColumnNamesSeen = Collections.emptyList();
        boolean hasLegacyCounterShards = false;
        if (this.deletionInfo().getTopLevelDeletion().localDeletionTime < Integer.MAX_VALUE) {
            tombstones.update(this.deletionInfo().getTopLevelDeletion().localDeletionTime);
            maxDeletionTimeTracker.update(this.deletionInfo().getTopLevelDeletion().localDeletionTime);
            minTimestampTracker.update(this.deletionInfo().getTopLevelDeletion().markedForDeleteAt);
            maxTimestampTracker.update(this.deletionInfo().getTopLevelDeletion().markedForDeleteAt);
        }
        Iterator<RangeTombstone> it = this.deletionInfo().rangeIterator();
        while (it.hasNext()) {
            RangeTombstone rangeTombstone = it.next();
            tombstones.update(rangeTombstone.getLocalDeletionTime());
            minTimestampTracker.update(rangeTombstone.timestamp());
            maxTimestampTracker.update(rangeTombstone.timestamp());
            maxDeletionTimeTracker.update(rangeTombstone.getLocalDeletionTime());
            minColumnNamesSeen = ColumnNameHelper.minComponents(minColumnNamesSeen, (Composite)rangeTombstone.min, this.metadata.comparator);
            maxColumnNamesSeen = ColumnNameHelper.maxComponents(maxColumnNamesSeen, (Composite)rangeTombstone.max, this.metadata.comparator);
        }
        for (Cell cell : this) {
            minTimestampTracker.update(cell.timestamp());
            maxTimestampTracker.update(cell.timestamp());
            maxDeletionTimeTracker.update(cell.getLocalDeletionTime());
            int deletionTime = cell.getLocalDeletionTime();
            if (deletionTime < Integer.MAX_VALUE) {
                tombstones.update(deletionTime);
            }
            minColumnNamesSeen = ColumnNameHelper.minComponents(minColumnNamesSeen, cell.name(), this.metadata.comparator);
            maxColumnNamesSeen = ColumnNameHelper.maxComponents(maxColumnNamesSeen, cell.name(), this.metadata.comparator);
            if (!(cell instanceof CounterCell)) continue;
            hasLegacyCounterShards = hasLegacyCounterShards || ((CounterCell)cell).hasLegacyShards();
        }
        return new ColumnStats(this.getColumnCount(), minTimestampTracker.get(), maxTimestampTracker.get(), maxDeletionTimeTracker.get(), tombstones, minColumnNamesSeen, maxColumnNamesSeen, hasLegacyCounterShards);
    }

    public boolean isMarkedForDelete() {
        return !this.deletionInfo().isLive();
    }

    public CellNameType getComparator() {
        return this.metadata.comparator;
    }

    public boolean hasOnlyTombstones(long now) {
        for (Cell cell : this) {
            if (!cell.isLive(now)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.getSortedColumns().iterator();
    }

    public Iterator<Cell> reverseIterator() {
        return this.getReverseSortedColumns().iterator();
    }

    public Map<CellName, ByteBuffer> asMap() {
        ImmutableMap.Builder<CellName, ByteBuffer> builder = ImmutableMap.builder();
        for (Cell cell : this) {
            builder.put(cell.name(), cell.value());
        }
        return builder.build();
    }

    public static ColumnFamily fromBytes(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return serializer.deserialize(new DataInputStream(ByteBufferUtil.inputStream(bytes)), ArrayBackedSortedColumns.factory, ColumnSerializer.Flag.LOCAL, 9);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer toBytes() {
        try (DataOutputBuffer out = new DataOutputBuffer();){
            serializer.serialize(this, (DataOutputPlus)out, 9);
            ByteBuffer byteBuffer = ByteBuffer.wrap(out.getData(), 0, out.getLength());
            return byteBuffer;
        }
    }

    public abstract BatchRemoveIterator<Cell> batchRemoveIterator();

    public static abstract class Factory<T extends ColumnFamily> {
        public abstract T create(CFMetaData var1, boolean var2, int var3);

        public T create(CFMetaData metadata, boolean insertReversed) {
            return this.create(metadata, insertReversed, 0);
        }

        public T create(CFMetaData metadata) {
            return this.create(metadata, false);
        }

        public T create(String keyspace, String cfName) {
            return this.create(Schema.instance.getCFMetaData(keyspace, cfName));
        }
    }
}

