/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.primitives.Ints;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ObjectSizes;

public class RowIndexEntry<T>
implements IMeasurableMemory {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new RowIndexEntry(0L));
    public final long position;

    public RowIndexEntry(long position) {
        this.position = position;
    }

    public int promotedSize(ISerializer<T> idxSerializer) {
        return 0;
    }

    public static RowIndexEntry<IndexHelper.IndexInfo> create(long position, DeletionTime deletionTime, ColumnIndex index) {
        assert (index != null);
        assert (deletionTime != null);
        if (index.columnsIndex.size() > 1) {
            return new IndexedEntry(position, deletionTime, index.columnsIndex);
        }
        return new RowIndexEntry<IndexHelper.IndexInfo>(position);
    }

    public boolean isIndexed() {
        return !this.columnsIndex().isEmpty();
    }

    public DeletionTime deletionTime() {
        throw new UnsupportedOperationException();
    }

    public long headerOffset() {
        return 0L;
    }

    public List<T> columnsIndex() {
        return Collections.emptyList();
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE;
    }

    private static class IndexedEntry
    extends RowIndexEntry<IndexHelper.IndexInfo> {
        private final DeletionTime deletionTime;
        private final List<IndexHelper.IndexInfo> columnsIndex;
        private static final long BASE_SIZE = ObjectSizes.measure(new IndexedEntry(0L, DeletionTime.LIVE, Arrays.asList(null, null))) + ObjectSizes.measure(new ArrayList(1));

        private IndexedEntry(long position, DeletionTime deletionTime, List<IndexHelper.IndexInfo> columnsIndex) {
            super(position);
            assert (deletionTime != null);
            assert (columnsIndex != null && columnsIndex.size() > 1);
            this.deletionTime = deletionTime;
            this.columnsIndex = columnsIndex;
        }

        @Override
        public DeletionTime deletionTime() {
            return this.deletionTime;
        }

        @Override
        public List<IndexHelper.IndexInfo> columnsIndex() {
            return this.columnsIndex;
        }

        @Override
        public int promotedSize(ISerializer<IndexHelper.IndexInfo> idxSerializer) {
            TypeSizes typeSizes = TypeSizes.NATIVE;
            long size = DeletionTime.serializer.serializedSize(this.deletionTime, typeSizes);
            size += (long)typeSizes.sizeof(this.columnsIndex.size());
            for (IndexHelper.IndexInfo info : this.columnsIndex) {
                size += idxSerializer.serializedSize(info, typeSizes);
            }
            return Ints.checkedCast(size);
        }

        @Override
        public long unsharedHeapSize() {
            long entrySize = 0L;
            for (IndexHelper.IndexInfo idx : this.columnsIndex) {
                entrySize += idx.unsharedHeapSize();
            }
            return BASE_SIZE + entrySize + this.deletionTime.unsharedHeapSize() + ObjectSizes.sizeOfReferenceArray(this.columnsIndex.size());
        }
    }

    public static class Serializer
    implements IndexSerializer<IndexHelper.IndexInfo> {
        private final ISerializer<IndexHelper.IndexInfo> idxSerializer;

        public Serializer(ISerializer<IndexHelper.IndexInfo> idxSerializer) {
            this.idxSerializer = idxSerializer;
        }

        @Override
        public void serialize(RowIndexEntry<IndexHelper.IndexInfo> rie, DataOutputPlus out) throws IOException {
            out.writeLong(rie.position);
            out.writeInt(rie.promotedSize(this.idxSerializer));
            if (rie.isIndexed()) {
                DeletionTime.serializer.serialize(rie.deletionTime(), out);
                out.writeInt(rie.columnsIndex().size());
                for (IndexHelper.IndexInfo info : rie.columnsIndex()) {
                    this.idxSerializer.serialize(info, out);
                }
            }
        }

        @Override
        public RowIndexEntry<IndexHelper.IndexInfo> deserialize(DataInput in, Version version) throws IOException {
            long position = in.readLong();
            int size = in.readInt();
            if (size > 0) {
                DeletionTime deletionTime = DeletionTime.serializer.deserialize(in);
                int entries = in.readInt();
                ArrayList<IndexHelper.IndexInfo> columnsIndex = new ArrayList<IndexHelper.IndexInfo>(entries);
                for (int i = 0; i < entries; ++i) {
                    columnsIndex.add(this.idxSerializer.deserialize(in));
                }
                return new IndexedEntry(position, deletionTime, columnsIndex);
            }
            return new RowIndexEntry<IndexHelper.IndexInfo>(position);
        }

        public static void skip(DataInput in) throws IOException {
            in.readLong();
            Serializer.skipPromotedIndex(in);
        }

        private static void skipPromotedIndex(DataInput in) throws IOException {
            int size = in.readInt();
            if (size <= 0) {
                return;
            }
            FileUtils.skipBytesFully(in, size);
        }

        @Override
        public int serializedSize(RowIndexEntry<IndexHelper.IndexInfo> rie) {
            int size = TypeSizes.NATIVE.sizeof(rie.position) + TypeSizes.NATIVE.sizeof(rie.promotedSize(this.idxSerializer));
            if (rie.isIndexed()) {
                List<IndexHelper.IndexInfo> index = rie.columnsIndex();
                size = (int)((long)size + DeletionTime.serializer.serializedSize(rie.deletionTime(), TypeSizes.NATIVE));
                size += TypeSizes.NATIVE.sizeof(index.size());
                for (IndexHelper.IndexInfo info : index) {
                    size = (int)((long)size + this.idxSerializer.serializedSize(info, TypeSizes.NATIVE));
                }
            }
            return size;
        }
    }

    public static interface IndexSerializer<T> {
        public void serialize(RowIndexEntry<T> var1, DataOutputPlus var2) throws IOException;

        public RowIndexEntry<T> deserialize(DataInput var1, Version var2) throws IOException;

        public int serializedSize(RowIndexEntry<T> var1);
    }
}

